<?php get_header(); ?>
<div class="categoryPage row">	
	<div class="eleven alpha columns">

	<?php if(is_archive()){ ?>

		<h1 class="page-title margin-bottom blog-archive">
            <?php $counter = 1; ?>
            <?php if ( is_day() ) : ?>
              <?php printf( __( 'Daily Archives: %s', 'twentyeleven' ), '<span>' . get_the_date() . '</span>' ); ?>
            <?php elseif ( is_month() ) : ?>
              <?php printf( __( 'Monthly Archives: %s', 'twentyeleven' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'twentyeleven' ) ) . '</span>' ); ?>
            <?php elseif ( is_year() ) : ?>
              <?php printf( __( 'Yearly Archives: %s', 'twentyeleven' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'twentyeleven' ) ) . '</span>' ); ?>
            <?php else : ?>
              <?php _e( 'Blog', 'twentyeleven' ); ?>
            <?php endif; ?>
      </h1>

	<?php } ?>
	
	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
		<div class="article">

			<?php if ( has_post_thumbnail()){ ?>

				<div class="four alpha columns">

					<?php if ( has_post_thumbnail()){ ?>

						<?php the_post_thumbnail('blog_image'); ?>

					<?php } else { ?>

						&nbsp;

					<?php } ?>

				</div>

				<div class="">

			
					<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
					<span class="date"><?php the_date('d-m-Y'); ?></span>
					
					<p><?php echo excerpt(50); ?></p>

					<span class="readMore"><a href="<?php the_permalink(); ?>">Read More</a></span>

				</div>

				<div class="clear"></div>
		

		<?php } else { ?>

				<div class="">

			
					<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
					<span class="date"><?php the_date('d-m-Y'); ?></span>
			
					<p><?php echo excerpt(50); ?></p>

					<span class="readMore"><a href="<?php the_permalink(); ?>">Read More</a></span>

				</div>

		<?php } ?>

			<div class="clear"></div>
	
		</div>


		<div class="clear"></div>

	<?php endwhile; else: ?>
	<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
	<?php endif; wp_reset_query(); ?>	
	      <div class="pagination">        
         <?php
              global $wp_query;
              $big = 999999999; // need an unlikely integer
              echo paginate_links( array(
                  'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
                  'format' => '?paged=%#%',
                  'current' => max( 1, get_query_var('paged') ),
                  'total' => $wp_query->max_num_pages,
                  'prev_text'    => __('&larr; Previous'),
            'next_text'    => __('Next &rarr;'),
              ) );
              ?> 
          </div>

	</div>

	<div class="five columns omega last">
		<?php get_sidebar(); ?>
	</div>
	<div class="clear"></div>
	
</div>
<?php get_footer(); ?>