<?php 


	register_nav_menus( array(
		'main' => __( 'Main Navigation', 'cje' ),
		'footer_1' => __( 'Footer 1 Navigation', 'cje' ),
		'footer_2' => __( 'Footer 2 Navigation', 'cje' ),
		'footer_3' => __( 'Footer 3 Navigation', 'cje' )
	) );	
		
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'banner', 960, 495, true );
	add_image_size( 'portfolio_image', 140, 140, true );

	function give_linked_images_class($html, $id, $caption, $title, $align, $url, $size, $alt = '' ){
	 
	  $classes = 'lightbox';

	  if ( preg_match('/<a.*? class=".*?">/', $html) ) {
	    $html = preg_replace('/(<a.*? class=".*?)(".*?>)/', '$1 ' . $classes . '$2', $html);
	  } else {
	    $html = preg_replace('/(<a.*?)>/', '$1 class="' . $classes . '" >', $html);
	  }
	  return $html;

	}
	add_filter('image_send_to_editor','give_linked_images_class',10,8);

	function excerpt($limit) {
		$excerpt = explode(' ', get_the_excerpt(), $limit);
		if (count($excerpt)>=$limit) {
		array_pop($excerpt);
		$excerpt = implode(" ",$excerpt).'...';
		} else {
		$excerpt = implode(" ",$excerpt);
		} 
		$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
		return $excerpt;
	}

	function content($limit) {
		$content = explode(' ', get_the_content(), $limit);
		if (count($content)>=$limit) {
		array_pop($content);
		$content = implode(" ",$content).'...';
		} else {
		$content = implode(" ",$content);
		} 
		$content = preg_replace('/\[.+\]/','', $content);
		$content = apply_filters('the_content', $content); 
		return $content;
	}

	function divide($atts, $content) {

		$atts = extract(shortcode_atts(array('id'=>''),$atts));

		return '<div class="divide" id="' . $id . '"></div>';

	}
	add_shortcode('divide', 'divide');

// Register Custom Post Type
function banner() {

	$labels = array(
		'name'                => _x( 'Banners', 'Post Type General Name', 'banner' ),
		'singular_name'       => _x( 'Banner', 'Post Type Singular Name', 'banner' ),
		'menu_name'           => __( 'Banner', 'banner' ),
		'parent_item_colon'   => __( 'Parent Item:', 'banner' ),
		'all_items'           => __( 'All Items', 'banner' ),
		'view_item'           => __( 'View Item', 'banner' ),
		'add_new_item'        => __( 'Add New Item', 'banner' ),
		'add_new'             => __( 'Add New', 'banner' ),
		'edit_item'           => __( 'Edit Item', 'banner' ),
		'update_item'         => __( 'Update Item', 'banner' ),
		'search_items'        => __( 'Search Item', 'banner' ),
		'not_found'           => __( 'Not found', 'banner' ),
		'not_found_in_trash'  => __( 'Not found in Trash', 'banner' ),
	);
	$args = array(
		'label'               => __( 'banner', 'banner' ),
		'description'         => __( 'Post Type Description', 'banner' ),
		'labels'              => $labels,
		'supports'            => array( 'title', 'editor', 'thumbnail', 'custom-fields', ),
		'taxonomies'          => array( 'banner_group' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'menu_position'       => 2,
		// 'menu_icon'           => '',
		'can_export'          => true,
		'has_archive'         => true,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'page',
	);
	register_post_type( 'banner', $args );

}

// Hook into the 'init' action
add_action( 'init', 'banner', 0 );
	// Register Custom Taxonomy
	function banner_group() {

		$labels = array(
			'name'                       => _x( 'Goups', 'Taxonomy General Name', 'banner_group' ),
			'singular_name'              => _x( 'Group', 'Taxonomy Singular Name', 'banner_group' ),
			'menu_name'                  => __( 'Taxonomy', 'banner_group' ),
			'all_items'                  => __( 'All Items', 'banner_group' ),
			'parent_item'                => __( 'Parent Item', 'banner_group' ),
			'parent_item_colon'          => __( 'Parent Item:', 'banner_group' ),
			'new_item_name'              => __( 'New Item Name', 'banner_group' ),
			'add_new_item'               => __( 'Add New Item', 'banner_group' ),
			'edit_item'                  => __( 'Edit Item', 'banner_group' ),
			'update_item'                => __( 'Update Item', 'banner_group' ),
			'separate_items_with_commas' => __( 'Separate items with commas', 'banner_group' ),
			'search_items'               => __( 'Search Items', 'banner_group' ),
			'add_or_remove_items'        => __( 'Add or remove items', 'banner_group' ),
			'choose_from_most_used'      => __( 'Choose from the most used items', 'banner_group' ),
			'not_found'                  => __( 'Not Found', 'banner_group' ),
		);
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'menu_position'       => 25,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
		);
		register_taxonomy( 'banner_group', array( 'banner' ), $args );

	}

	// Hook into the 'init' action
	add_action( 'init', 'banner_group', 0 );



	/*XML Reader*/

	function xml2array($url, $get_attributes = 1, $priority = 'tag'){
	    $contents = "";
	    if (!function_exists('xml_parser_create'))
	    {
	        return array ();
	    }
	    $parser = xml_parser_create('');
	    if (!($fp = @ fopen($url, 'rb')))
	    {
	        return array ();
	    }
	    while (!feof($fp))
	    {
	        $contents .= fread($fp, 8192);
	    }
	    fclose($fp);
	    xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, "UTF-8");
	    xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	    xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
	    xml_parse_into_struct($parser, trim($contents), $xml_values);
	    xml_parser_free($parser);
	    if (!$xml_values)
	        return; //Hmm...
	    $xml_array = array ();
	    $parents = array ();
	    $opened_tags = array ();
	    $arr = array ();
	    $current = & $xml_array;
	    $repeated_tag_index = array ();
	    foreach ($xml_values as $data)
	    {
	        unset ($attributes, $value);
	        extract($data);
	        $result = array ();
	        $attributes_data = array ();
	        if (isset ($value))
	        {
	            if ($priority == 'tag')
	                $result = $value;
	            else
	                $result['value'] = $value;
	        }
	        if (isset ($attributes) and $get_attributes)
	        {
	            foreach ($attributes as $attr => $val)
	            {
	                if ($priority == 'tag')
	                    $attributes_data[$attr] = $val;
	                else
	                    $result['attr'][$attr] = $val; //Set all the attributes in a array called 'attr'
	            }
	        }
	        if ($type == "open")
	        {
	            $parent[$level -1] = & $current;
	            if (!is_array($current) or (!in_array($tag, array_keys($current))))
	            {
	                $current[$tag] = $result;
	                if ($attributes_data)
	                    $current[$tag . '_attr'] = $attributes_data;
	                $repeated_tag_index[$tag . '_' . $level] = 1;
	                $current = & $current[$tag];
	            }
	            else
	            {
	                if (isset ($current[$tag][0]))
	                {
	                    $current[$tag][$repeated_tag_index[$tag . '_' . $level]] = $result;
	                    $repeated_tag_index[$tag . '_' . $level]++;
	                }
	                else
	                {
	                    $current[$tag] = array (
	                        $current[$tag],
	                        $result
	                    );
	                    $repeated_tag_index[$tag . '_' . $level] = 2;
	                    if (isset ($current[$tag . '_attr']))
	                    {
	                        $current[$tag]['0_attr'] = $current[$tag . '_attr'];
	                        unset ($current[$tag . '_attr']);
	                    }
	                }
	                $last_item_index = $repeated_tag_index[$tag . '_' . $level] - 1;
	                $current = & $current[$tag][$last_item_index];
	            }
	        }
	        elseif ($type == "complete")
	        {
	            if (!isset ($current[$tag]))
	            {
	                $current[$tag] = $result;
	                $repeated_tag_index[$tag . '_' . $level] = 1;
	                if ($priority == 'tag' and $attributes_data)
	                    $current[$tag . '_attr'] = $attributes_data;
	            }
	            else
	            {
	                if (isset ($current[$tag][0]) and is_array($current[$tag]))
	                {
	                    $current[$tag][$repeated_tag_index[$tag . '_' . $level]] = $result;
	                    if ($priority == 'tag' and $get_attributes and $attributes_data)
	                    {
	                        $current[$tag][$repeated_tag_index[$tag . '_' . $level] . '_attr'] = $attributes_data;
	                    }
	                    $repeated_tag_index[$tag . '_' . $level]++;
	                }
	                else
	                {
	                    $current[$tag] = array (
	                        $current[$tag],
	                        $result
	                    );
	                    $repeated_tag_index[$tag . '_' . $level] = 1;
	                    if ($priority == 'tag' and $get_attributes)
	                    {
	                        if (isset ($current[$tag . '_attr']))
	                        {
	                            $current[$tag]['0_attr'] = $current[$tag . '_attr'];
	                            unset ($current[$tag . '_attr']);
	                        }
	                        if ($attributes_data)
	                        {
	                            $current[$tag][$repeated_tag_index[$tag . '_' . $level] . '_attr'] = $attributes_data;
	                        }
	                    }
	                    $repeated_tag_index[$tag . '_' . $level]++; //0 and 1 index is already taken
	                }
	            }
	        }
	        elseif ($type == 'close')
	        {
	            $current = & $parent[$level -1];
	        }
	    }
	    return ($xml_array);
	}


	function button_expand($id, $title, $class) {



		$html = '<p class="pull-right"><a href="" id="'.$id.'_button" class="blueBtn pull-right expand_btn ' . $class . '">' . $title . '</a></p><div class="clear"></div>';

		$js = '<script type="text/javascript">';
		$js .= '$(document).ready(function(){';
		$js .= '$("#'.$id.'_button").live("click", function(e){';
		$js .= 'e.preventDefault();';
		$js .= '$("#'.$id.'").slideToggle(200).toggleClass("active");';
		$js .= 'if($("#'.$id.'").hasClass("active")){ $("#'.$id.'_button").attr("data-oldtext",$("#'.$id.'_button").text()); $("#'.$id.'_button").text("Close"); } else { $("#'.$id.'_button").text($("#'.$id.'_button").attr("data-oldtext")); $("#'.$id.'_button").attr("data-oldtext", ""); }';
		$js .= '});';
		$js .= '});';
		$js .= '</script>';

		return $html . $js;
 
	}

	function expand_shortcode($atts, $content) {

		$atts = extract(shortcode_atts(array('title'=>'Heading Title', 'class' => '', 'option' => '', 'optional_text'),$atts));

		$id = array_sum(explode(' ', microtime())) . md5(rand(0, 10000)) . md5(rand(500,58000));
		$id = sha1(str_replace('.', '', $id));

		//$id =  md5($option);

		$button = button_expand($id, $title, $class);

		return '<div id="'.$id.'" class="expand">' . $content . '</div>' . $button;

	}

	add_shortcode('expand', 'expand_shortcode');

	function lets_talk_button($atts) {
		$atts = extract(shortcode_atts(array('subject'=>'', 'name' => ''),$atts));
		return '<a class="orangeBtn" href="' . add_query_arg(array('subject' => $subject), get_permalink(16)) . '">' . $name . '</a>';
	}
	add_shortcode('lets_talk_button', 'lets_talk_button');

	// function expand_close_shortcode() {

	// 	return '</div>';

	// }

	// add_shortcode('expand_close', 'expand_close_shortcode');

 
 ?>