<!doctype html>
<html lang="en-US">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Default Page Title</title>
  <link href="//netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('stylesheet_url'); ?>">
  <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('template_directory'); ?>/assets/js/bx/jquery.bxslider.css">
  <link href="//netdna.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet">

  <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.1/jquery.min.js"></script>
  <script type="text/javascript" src="<?php echo get_bloginfo('template_directory'); ?>/assets/js/bx/jquery.bxslider.min.js"></script>
  <script type="text/javascript" src="<?php echo get_bloginfo('template_directory'); ?>/assets/js/script.js"></script>
  <!--[if lt IE 9]>
  <script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
  <![endif]-->

  <?php wp_head(); ?>

</head>

<body>

  <header>

    <div class="container container-sixteen">
      <div class="sixteen columns <?php if(!is_front_page()){ echo 'bordered'; } ?>">

        <div class="logoContainer">
          <a href="<?php echo site_url(); ?>"><img src="<?php echo get_bloginfo( 'template_directory' ); ?>/assets/img/logo.png" alt="" /></a>
        </div>

        <nav class="pull-right">
          <div class="nav_wrapper">
            <div class="nav_toggle">
              <div>
                <span></span>
                <span></span>
                <span></span>
              </div>
            </div>
            <?php wp_nav_menu( array( 'theme_location' => 'main')); ?> 
          </div>
        </nav>

      </div>
    </div>

    <div class="containter mobile_menu">
        <?php wp_nav_menu( array( 'theme_location' => 'main')); ?> 
    </div>

    <div class="clear"></div>

  </header>

   <?php if(is_front_page() || is_page(4) || is_page(6) || is_page(8)){ ?>

      <div class="bannerWrapper">
          <?php 
            wp_reset_query(); 
            query_posts(array('post_type' => 'banner', 'tax_query' => array(array('taxonomy' => 'banner_group','terms' => get_post_meta($post->ID, 'banner_category', true),'field' => 'term_id'))));
          ?>
          <div class="banner container">
            <div id="slider">
              <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                 <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'banner' ); ?>
                    <div class="banner_item" >
                      <img src="<?php echo $image[0]; ?>">
                        <div class="container container-sixteen container container-sixteen-twelve">
                          <div class="caption twelve columns">
                            <strong><?php the_title(); ?></strong><br />
                            <span><?php the_content(); ?></span>
                            <?php if ( get_post_meta($post->ID, 'link', true) != '' ) { ?>
                              <a href="<?php echo get_post_meta($post->ID, 'link', true); ?>" class="readMore orangeBtn">Read More</a>
                            <?php } ?>
                          </div>
                        </div>
                    </div>
              <?php endwhile; endif; wp_reset_query(); ?>
            </div>
        </div>
      </div>

    <?php if(is_front_page()){  ?>
	    <div class="zones">
	      <div class="container container-sixteen">
	          <div class="fiftypercent first">
	            <a href="<?php echo get_permalink(6); ?>">

	              <span>Click here to enter the</span>
	              <strong>CLIENT ZONE</strong>
	            </a>
	            <div class="clear"></div>
	          </div><div class="fiftypercent">
	            <a href="<?php echo get_permalink(8); ?>">

	              <span>Click here to enter the</span>
	              <strong>CANDIDATE ZONE</strong>

	            </a>
	            <div class="clear"></div>
	          </div>
	      </div>
	    </div>

	    <div class="container container-sixteen homeSection">
	          <div class="eight columns first ">
	            
	            <div class="paddingBox">
                <h2>Free Introductory Offer</h2>
	              <strong>Not recruiting? Sign up &amp; benefit when you're ready</strong>
                <br />
	              <ul>
	                <li><i class="fa fa-check"></i>&nbsp;Free SME Seminars</li>
	                <li><i class="fa fa-check"></i>&nbsp;Free CV Check</li>
	                <li><i class="fa fa-check"></i>&nbsp;Recruitment Hot Topics For Job Seekers &amp; Hirers</li>
	                <li><i class="fa fa-check"></i>&nbsp;Webinars</li>
	                <li><i class="fa fa-check"></i>&nbsp;SME Newsletter</li>
	              </ul>
	              <a href="<?php echo add_query_arg(array('subject' => 'Free Introductory Offer'), get_permalink(16)); ?>" class="blueBtn">Sign Up Now!</a>
	            </div>

	            <div class="clear"></div>
	          </div>
	          <div class="eight columns second">
	           <a class="twitter-timeline"  href="https://twitter.com/CJEResourcing"  data-widget-id="467233610500538368">Tweets by @CJEResourcing</a>
             <script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>


	            <div class="clear"></div>
	          </div>
	      </div>
	    <?php } ?>
  <?php } ?>

  <section class="main">

  <?php if(is_page(6) || is_page(8)){ ?>
  	<div class="container container-twelve mainContent">
	    <div class="twelve columns">
  <?php } else { ?>
	<div class="container container-sixteen mainContent">
		<div class="sixteen columns">
  <?php } ?>