<?php
session_start();
include '../config/functions.php';
@include '../langauge/'.$_SESSION['lang'].'.php';

// set $db as variable for mysql functions
$db = db_connect();

$sel_unassigned_tickets = mysqli_query($db, "SELECT * FROM $mysql_ticket WHERE Owner IS NULL") or die("Fault selecting unassigned from tickets table");

$unassigned_ticket_count = mysqli_num_rows($sel_unassigned_tickets);

$sel_tickets_by_group = mysqli_query($db, "SELECT Cat_ID, Category FROM $mysql_categories ORDER BY Category ASC") or die ("Failed to get tickets by group");

// total up ticket statuses
$ticket_total = aa_dashboard_count_totals("Open") + 
				aa_dashboard_count_totals("Pending") + 
				aa_dashboard_count_totals("Paused") +
				aa_dashboard_count_totals("Closed");			
?>

<div>
	<div class="pad10">
    <h3>
    <a class="summary_block open-color" status="Open" href="#"><?php echo @$lang['tickets-status-open']; ?> <?php echo aa_dashboard_count_totals("Open"); ?></a>
    <a class="summary_block pending-color" status="Pending" href="#"><?php echo @$lang['tickets-status-pending']; ?> <?php echo aa_dashboard_count_totals("Pending"); ?></a>
    <a class="summary_block paused-color" status="Paused" href="#"><?php echo @$lang['tickets-status-paused']; ?> <?php echo aa_dashboard_count_totals("Paused"); ?></a> 
    <a class="summary_block closed-color" status="Closed" href="#"><?php echo @$lang['tickets-status-closed']; ?> <?php echo aa_dashboard_count_totals("Closed"); ?></a>
    <a class="summary_block" status="Unassigned" href="#"><?php echo @$lang["generic-unassigned"]; ?> <?php echo $unassigned_ticket_count; ?></a>
    Total <?php echo $ticket_total; ?>
    </h3>
    </div>
</div>

<br />

<div id="aa-dashboard-gs" class="body-box bg-color-body-inner border-color">
<div class="pad10">
<h3><i class="fa fa-bar-chart"></i> <?php echo @$lang['dash-group-sum']; ?></h3>
<table>
<thead>
<tr>
<th>&nbsp;</th>
<th class="open-color"><?php echo @$lang['tickets-status-open']; ?></th>
<th class="pending-color"><?php echo @$lang['tickets-status-pending']; ?></th>
<th class="paused-color"><?php echo @$lang['tickets-status-paused']; ?></th>
<th class="closed-color"><?php echo @$lang['tickets-status-closed']; ?></th>
<th><?php echo @$lang["generic-unassigned"]; ?></th>
</tr>
</thead>
<tbody>
<?php
function aa_count_tickets_by_status($group, $status) {
	global $db;
	if ($status != "NULL") {
	$count_tickets_by_status = mysqli_query($db, "SELECT * FROM  `ticket` WHERE Cat_ID = '$group' AND Status =  '$status'") or die ("Failed to count tickets by group");
	} else {
	$count_tickets_by_status = mysqli_query($db, "SELECT * FROM  `ticket` WHERE Cat_ID = '$group' AND Owner IS NULL") or die ("Failed to count tickets by group");
	}
	return $group_status_total = mysqli_num_rows($count_tickets_by_status);
}

while ($t_group = mysqli_fetch_array($sel_tickets_by_group)) {

echo "<tr><td>".$t_group['Category']."</td>
<td class=\"open-color\" data-title=\"".@$lang['tickets-status-open']."\"><a class=\"summary_block open-color\" group=\"".$t_group['Cat_ID']."\" status=\"Open\" href=\"#\">".aa_count_tickets_by_status($t_group['Cat_ID'], 'Open')."</a></td>
<td class=\"pending-color\" data-title=\"".@$lang['tickets-status-pending']."\"><a class=\"summary_block pending-color\" group=\"".$t_group['Cat_ID']."\" status=\"Pending\" href=\"#\">".aa_count_tickets_by_status($t_group['Cat_ID'], 'Pending')."</a></td>
<td class=\"paused-color\" data-title=\"".@$lang['tickets-status-paused']."\"><a class=\"summary_block paused-color\" group=\"".$t_group['Cat_ID']."\" status=\"Paused\" href=\"#\">".aa_count_tickets_by_status($t_group['Cat_ID'], 'Paused')."</a></td>
<td class=\"closed-color\" data-title=\"".@$lang['tickets-status-closed']."\"><a class=\"summary_block closed-color\" group=\"".$t_group['Cat_ID']."\" status=\"Closed\" href=\"#\">".aa_count_tickets_by_status($t_group['Cat_ID'], 'Closed')."</a></td>
<td data-title=\"".@$lang["generic-unassigned"]."\"><a class=\"summary_block\" group=\"".$t_group['Cat_ID']."\" status=\"Unassigned\" href=\"#\">".aa_count_tickets_by_status($t_group['Cat_ID'], 'NULL')."</a></td>
</tr>";

}
?>
</tbody>
</table>
<div style="text-align:center; font-size:small;"><p><?php echo @$lang['dash-group-table-text']; ?></p></div>
</div>
</div>