<?php
@session_start();

include '../config/functions.php';


$var = $_POST;

$_SESSION["filter_agents"] = $var["user"];
$_SESSION["filter_groups"] = @$var["groups"];
$_SESSION["filter_status"] = @$var["status"];
$_SESSION["filter_priority"] = @$var["priority"];
$_SESSION["filter_sortby"] = $var["filter_sortval"];
$_SESSION["filter_sortdir"] = $var["filter_sortdir"];
$_SESSION["filter_dateadded"] = $var["filter_dateadded"];

$_SESSION["ticket_vew"] = $var['ticket_view'];

@$dt = $var["dt"];
$lastdt = date("Y-m-d H:i:s", strtotime($dt.'-15 seconds'));

//print_r($var);

if (isset($dt)) {
	// less than the current time but greater than the previous time
	$sql_updates_only = " AND (t.Date_Added > '".aa_mysqli_escape($lastdt)."')";
	
} else {
	
	$sql_updates_only = "";
	
}

	//print_r($_POST);
	switch ($_SESSION["filter_dateadded"]) {
		case "today":
			$filter_date_from = aa_mysqli_escape(date("Y-m-d",strtotime("today")));
			$filter_date_to = aa_mysqli_escape(date("Y-m-d",strtotime("tomorrow")));
			break;
		case "yesterday":
			$filter_date_from = aa_mysqli_escape(date("Y-m-d",strtotime("yesterday")));
			$filter_date_to = aa_mysqli_escape(date("Y-m-d",strtotime("today")));
			break;
		case "this_week":
			$filter_date_from = aa_mysqli_escape(date("Y-m-d",strtotime("monday this week")));
			$filter_date_to = aa_mysqli_escape(date("Y-m-d",strtotime("tomorrow")));
			break;
		case "last_week":
			$filter_date_from = aa_mysqli_escape(date("Y-m-d",strtotime("monday last week")));
			$filter_date_to = aa_mysqli_escape(date("Y-m-d",strtotime("monday this week")));
			break;
		case "this_month":
			$filter_date_from = aa_mysqli_escape(date("Y-m-d",strtotime("first day of this month")));
			$filter_date_to = aa_mysqli_escape(date("Y-m-d",strtotime("tomorrow")));
			break;
		case "last_month":
			$filter_date_from = aa_mysqli_escape(date("Y-m-d",strtotime("first day of last month")));
			$filter_date_to = aa_mysqli_escape(date("Y-m-d",strtotime("first day of this month")));
			break;	
		case "anytime":
			$filter_date_from = aa_mysqli_escape(@$_POST["rep_period_from"]);
			$report_date_to = aa_mysqli_escape(@$_POST["rep_period_to"]);
			break;
		}

/*
print_r($var);

echo "<p></p>";

print_r($_SESSION["filter_status"]);

echo "<p></p>";


echo "<p></p>";
*/

$loguid = aa_mysqli_escape(@$_SESSION["acornaid_user"]);

function combine_array ($sqlfield, $arrayname) {

	if(is_array($arrayname)) {
			
		foreach($arrayname as $value) {
			
			// escape value string
			$value = aa_mysqli_escape($value);
			
			if ($value == "NULL") {
				@$str .= "$sqlfield IS NULL OR ";	
			} else if (isset($value)) {
				@$str .= "$sqlfield = '$value' OR ";	
			} 
		}
		
	}
	
	// show priorities with default of 0
	if ($sqlfield == "t.Level_ID") {
		$str .= "t.Level_ID = '0'";
		}
					
	@$str = rtrim($str, " OR ");
	$complete_str = "(".$str.")";
	return $complete_str;
	
}

$sql_agents = combine_array("t.Owner", $_SESSION["filter_agents"]);
$sql_groups = combine_array("t.Cat_ID", $_SESSION["filter_groups"]);
$sql_status = combine_array("t.Status", $_SESSION["filter_status"]);

if ($_SESSION["filter_dateadded"] != "anytime") {
	$sql_dateadd = " AND (t.Date_Added BETWEEN '$filter_date_from' AND '$filter_date_to')".$sql_updates_only;
} else {
	$sql_dateadd = $sql_updates_only;
}

if (isset($_SESSION["filter_priority"])) {
$sql_priority = combine_array("t.Level_ID", $_SESSION["filter_priority"]);
}

// statement for filter
$wheresql = rtrim("WHERE ".$sql_agents." AND ".$sql_groups." AND ".$sql_status." AND ".@$sql_priority.$sql_dateadd." AND t.Type != 'Chat' ORDER BY ".$_SESSION["filter_sortby"]." ".$_SESSION["filter_sortdir"], " AND ");


// starting live code
// include @ to avoid errors once log in session has expired
@include '../langauge/'.$_SESSION['lang'].'.php';

// set $db as variable for mysql functions
$db = db_connect();

$date_format = get_settings('Date_Format');


// remove skilled join to show all tickets. prevent changes via the ticket it's self
$sel_tickets = mysqli_query($db, "SELECT
								t.ID, 
								t.Subject,
								t.Type,
								t.User,
								t.Status,
								DATE_FORMAT(t.Date_Added, '$date_format') AS DateAdd,
								DATE_FORMAT(t.Date_Updated, '$date_format') AS DateUp,
								t.Cat_ID,
								CASE t.Cat_ID WHEN c.Cat_ID THEN c.Category ELSE NULL END Category,
								t.Level_ID,
								CASE t.Level_ID WHEN p.Level_ID THEN p.Level ELSE NULL END Priority,
								t.Owner,
								(CASE WHEN t.Owner IS NULL THEN 'Unassigned' ELSE CONCAT(u.Fname, ' ' ,u.Lname) END) AS Owned
								FROM $mysql_ticket AS t
								LEFT JOIN $mysql_categories AS c ON t.Cat_ID = c.Cat_ID LEFT JOIN $mysql_priorities AS p ON t.Level_ID = p.Level_ID 
								LEFT JOIN $mysql_users AS u ON t.Owner = u.UID
								$wheresql");
								

$sel_agent_skills = mysqli_query($db, "SELECT * FROM $mysql_users_skill WHERE UID = '$loguid'");
$array_of_skills = array();
while ($agent_skill = mysqli_fetch_array($sel_agent_skills)) {
	array_push($array_of_skills, $agent_skill["CID"]);
}

//print_r	($array_of_skills);							
							
?>



	<?php
    while ($ticket = @mysqli_fetch_array($sel_tickets)) {
	
	// select last ticket update for expanded view	
	$sel_last_update = mysqli_query($db, "SELECT Notes FROM $mysql_ticket_updates WHERE Ticket_ID = '".$ticket["ID"]."' ORDER BY Updated_At DESC LIMIT 1");								
	$ticket_update = mysqli_fetch_array($sel_last_update);
	
	switch ($ticket["Status"]) {
		case "Open":
			$row = "open";
			$td = "open";
			break;
		case "Pending":
			$row = "";		
			$td = "pending";		
			break;
		case "Paused":
			$row = "";		
			$td= "paused";
			break;
		case "Closed":
			$row = "";		
			$td = "closed";
			break;	
		default:
			$row = "";
			$td = "";
	}    
?>
        
        <div class="ticket" id="<?php echo $ticket["ID"]; ?>">
        <div class="ticket_color <?php echo $td; ?>">&nbsp;</div>

		<div class="ticket_tick">
        <?php 
		// if skilled in group allowed to manage many
		if (in_array($ticket["Cat_ID"], $array_of_skills)) {
		?>	
        <input type="checkbox" class="checkbox" name="checked_ticket" id="<?php echo $ticket["ID"]; ?>" value="<?php echo $ticket["ID"]; ?>" />
        <?php
		} else {
		?>
        <input disabled="disabled" type="checkbox" class="checkbox" name="checked_ticket" id="<?php echo $ticket["ID"]; ?>" value="<?php echo $ticket["ID"]; ?>" />
		<?php
		}
		?>
        </div>
        
        <?php
		if ($var['ticket_view'] == 'List') {
		?>
        
			<div class="tl ticket-list-subject">
			<a href="page.php?page=page.ticket&tid=<?php echo $ticket["ID"]; ?>"><?php echo html_entity_decode(stripslashes($ticket["Subject"])); ?></a>
			</div>
			<div class="tl ticket-list hide-mobile">
			<?php echo aa_select_ticket_status_lang($ticket["Status"]); ?>
			</div>
			<div class="tl ticket-list">
			<?php echo decode_entities($ticket["Category"]); ?>
			</div>
			<div class="tl ticket-list hide-mobile">
			<?php echo decode_entities($ticket["Priority"]); ?>        
			</div>
			<div class="tl ticket-list">
			<?php echo $ticket["DateUp"]; ?>
			</div>
            
		<?php
		} else {
		?>

            <div class="ticket_summary">
            <?php echo "<p class=\"pagetitle\"><strong><a href=\"page.php?page=page.ticket&tid=".$ticket["ID"]."\">".html_entity_decode(stripslashes($ticket["Subject"]))."</a></strong></p>
            <span class=\"detail\"><i style=\"margin-left:0px\" class=\"fa fa-plus-square\"></i> ".aa_select_ticket_status_lang($ticket["Status"])."
            <i class=\"fa fa-folder\"></i> ".decode_entities($ticket["Category"])."
            <i class=\"fa fa-flag\"></i> ".decode_entities($ticket["Priority"])."
            <i class=\"fa fa-user\"></i> ".decode_entities($ticket["Owned"])."
            ".aa_select_ticket_type_lang($ticket['Type'])."</span>"; ?>
            <p>
            <i>
			<?php
			$content = strip_tags(decode_entities($ticket_update['Notes']));
			$dot = ".";
		
			$position = stripos ($content, $dot); //find first dot position
			$first_one = substr($content, 0, $position+1);
			
			if($position) { //if there's a dot in our soruce text do
			
				$offset = $position + 1; //prepare offset
				$position2 = stripos ($content, $dot, $offset); //find second dot using offset
			
				if($position2) { // if there is a second dot
					$first_two = substr($content, 0, $position2); //put two first sentences under $first_two
				
					echo $first_two . '.'; //add a dot
					
				} else { // else show sentence one
					
					echo $first_one;
					
				}
				
			} else if(!$content) {
				
				echo $lang['tickets-exp-noup'];
			
			} else {  //if there are no dots
				
				echo $content;
			
			}			
			?>
            </i>
            </p>
            </div>
            <div class="ticket_numbers">
            <?php 
            echo '<i class="fa fa-calendar"></i>'.$lang['search-added'].' '.$ticket["DateAdd"].'
            <br><i class="fa fa-calendar"></i>'.$lang['search-updated'].' '.$ticket["DateUp"].'
            <br>#'.$ticket["ID"];  ?>
            </div>
        
        <?php
		}
		?>
        
        </div>
	<?php
	// end while loop
	}
	?>