<?php

// include custom functions
include '../config/functions.php';

// set $db as variable for mysql functions
$db = db_connect();
$now = timezone_time();

// get ticket assignment
$ticket_assignment = get_settings("Ticket_Assignment");
if ($ticket_assignment == NULL) {
	$assignment = "NULL";
} else {
	$assignment = $ticket_assignment;
}

// select accounts that are not disabled
$sel_imail = mysqli_query($db, "SELECT * FROM $mysql_imail WHERE disabled = 0") or die(mysqli_error);

	while ($imail = mysqli_fetch_array($sel_imail)) { 

		/* connect to mail */
		$email_addr = $imail['Email_Addr'];
		$host = $imail['Email_Host'];
		$port = $imail['Port_No']; // port
		$service = "/".$imail['Protocol']; // imap, imap2, imap2bis, imap4, imap4rev1, pop3, nntp
		
		// ssl
		if($imail['Email_SSL'] == 1) {
			$ssl = "/ssl";
		} else {
			$ssl = "";
		}
		
		// tls, notls
		if($imail['Email_TLS'] == 1) {
			$tls = "/tls";
		} else {
			$tls = "/notls";
		}
	
		// /novalidate-cert, /validate-cert
		$cert = $imail['Val_Cert'];

		// email folder
		$folder = $imail['Email_Folder'];
		
		// group and level for email to be place into
		$group = $imail['Email_Group'];
		$level = $imail['Priority'];
		
		$server = "{".$host.":".$port.$service.$cert.$ssl.$tls."}".$folder;
		$login = $imail['Email_User'];
		$pwd = $imail['Email_Pass'];
		
		// count for each account
		$i=0;
		
		// open connection for each account
		$connection[$i] = imap_open($server, $login, $pwd);


		// count number of emails in each account / connection
		$emails[$i] = imap_search($connection[$i],'UNSEEN');
		//$emails[$i] = imap_sort($connection[$i], SORTARRIVAL,1);
		@rsort($emails[$i]);
		
		if (empty($emails[$i])) {
			
			echo '<p style="color:red">No messages to get from mailbox '.$email_addr.'</p>
				<p><hr></p>';
		
		// if more than one message in mailbox		
		} else if ($emails[$i] > 1) {
			
			foreach($emails[$i] as $e) {
			
				$emailMessage = new EmailMessage($connection[$i], $e);
				// set to true to get the message parts (or don't set to false, the default is true)
				$emailMessage->getAttachments = false;
				$emailMessage->fetch();
				$emailMessage->fetchoverview();
				//print_r($emailMessage);
				
				// if body contains html only show html else show plain
				if (!empty($emailMessage->bodyHTML)) {
					$emailbody = $emailMessage->bodyHTML;
				} else {
					$emailbody = $emailMessage->bodyPlain;
				}
								
				// set variables from mail to insert into sql		
				$user = mysqli_real_escape_string($db, $emailMessage->fromname);
				$user_email = mysqli_real_escape_string($db, $emailMessage->fromaddress);	
				$subject = mysqli_real_escape_string($db, $emailMessage->subject);
				
				// if email from no display name then use email address as customer.
				$customer = ($user == "") ? $user_email : $user;
				
				// cut off any text after reply above
				if (strpos($emailbody, '---- reply above this line ---') !== false) {
				$emailbody = substr($emailbody, 0, strpos($emailbody, '---- reply above this line ---'));
				}
				
				$emailbody = strip_html_tags($emailbody);
								
				$emailbody = form_field_clean($emailbody, FALSE);

				// use function to insert into mysql
				insert_into_mysql($subject);				
				
				echo '<p>'.$customer." - ".$emailMessage->subject.'</p>
					'.html_entity_decode($emailbody).'
					<p><hr></p>';
				
			}
		
		// if only 1 message in mailbox do not loop	
		} else if ($emails[$i] == 1) {

				$emailMessage = new EmailMessage($connection[$i], $email[$i]);
				// set to true to get the message parts (or don't set to false, the default is true)
				$emailMessage->getAttachments = false;
				$emailMessage->fetch();
				$emailMessage->fetchoverview();
				//print_r($emailMessage);
			
				// if body contains html only show html else show plain
				if (!empty($emailMessage->bodyHTML)) {
					echo $emailbody = $emailMessage->bodyHTML;
				} else {
					echo $emailbody = $emailMessage->bodyPlain;
				}
								
				// set variables from mail to insert into sql		
				$user = mysqli_real_escape_string($db, $emailMessage->fromname);
				$user_email = mysqli_real_escape_string($db, $emailMessage->fromaddress);	
				$subject = mysqli_real_escape_string($db, $emailMessage->subject);

				$customer = ($user == "") ? $user_email : $user;

				// cut off any text after reply above
				if (strpos($emailbody, '---- reply above this line ---') !== false) {
				$emailbody = substr($emailbody, 0, strpos($emailbody, '---- reply above this line ---'));
				}

				$emailbody = strip_html_tags($emailbody);

				$emailbody = form_field_clean($emailbody, FALSE);

				// use function to insert into mysql
				insert_into_mysql($subject);
				
				echo '<p>'.$customer." - ".$emailMessage->subject.'</p>
					<p><hr></p>';						

		} else {
	
			echo 'Unknown error whilst getting emails';
		
		}
		
		
	imap_errors();
	imap_alerts();
	imap_close($connection[$i]);
	// increase count
	$i++;
// end while
	
}

// function to insert email into sql
function insert_into_mysql($sub) {

	global $db,
			$mysql_ticket,
			$mysql_ticket_updates,
			$customer,
			$user_email,
			$group,
			$level,
			$subject,
			$assignment,
			$now,
			$emailbody;
			

	if (preg_match("/([0-9]{7})/", $sub, $matches)) {
		
		// select existing tickets
		$select_ex_id = mysqli_query($db, "SELECT ID, Status FROM $mysql_ticket WHERE ID = ".$matches[0]." AND Status != 'Closed'");
		$existing_id = mysqli_num_rows($select_ex_id);
		
		if ($existing_id > 0) {

			// set update ticket
			mysqli_query($db, "UPDATE $mysql_ticket SET Status = 'Pending', Date_Updated = '$now' WHERE ID = '".$matches[0]."'");
					
			// insert update into ticket updates
			mysqli_query($db, "INSERT INTO $mysql_ticket_updates (Ticket_ID, Update_By, Updated_At, Update_Type, Notes, Update_Emailed)
			VALUES ('".$matches[0]."', '$customer', '$now', 'Email', '$emailbody', 1)") or die(mysql_error());

			// notify the owner of the updates
			send_email_notification_up_ticket($matches[0]);
		
		} else {

			// add new ticket
			mysqli_query($db, "INSERT INTO $mysql_ticket (User, User_Email, Cat_ID, Level_ID, Type, Subject, Message, Status, Owner, Date_Added, Date_Updated) 
			VALUES ('$customer', '$user_email', '$group', '$level', 'Email', '$subject', '$emailbody', 'Open', $assignment, '$now', '$now')") or die(mysql_error());  
			
			$lastid = mysqli_insert_id($db);			
				
			send_email_update($lastid, "Open", $user_email, $emailbody);
			
			// send notification of new ticket to selected users
			send_email_notification_new_ticket('A new ticket ['.$lastid.'] has been submitted', $subject.'<p>---</p><p>'.decode_entities($emailbody).'</p>'); 	
		
		}
		
	// else new record
	} else {
		
		mysqli_query($db, "INSERT INTO $mysql_ticket (User, User_Email, Cat_ID, Level_ID, Type, Subject, Message, Status, Owner, Date_Added, Date_Updated) 
		VALUES ('$customer', '$user_email', '$group', '$level', 'Email', '$subject', '$emailbody', 'Open', $assignment, '$now', '$now')") or die(mysql_error());  

		$lastid = mysqli_insert_id($db);
		
		send_email_update($lastid, "Open", $user_email, $emailbody);

		// send notification of new ticket to selected users
		send_email_notification_new_ticket('A new ticket ['.$lastid.'] has been submitted', $subject.'<p>---</p><p>'.decode_entities($emailbody).'</p>'); 			

	}


}

// CLASS BEGINS
class EmailMessage {

	protected $connection;
	protected $messageNumber;
	
	public $fromname = '';
	public $fromaddress = '';
	public $subject = '';
	public $bodyHTML = '';
	public $bodyPlain = '';
	public $attachments;
	
	public $getAttachments = true;
	
	// connect to email server
	public function __construct($connection, $messageNumber) {
	
		$this->connection = $connection;
		$this->messageNumber = $messageNumber;
		
	}
	
	// fetch email details
	public function fetchoverview() {
	
		$overview = imap_headerinfo($this->connection, $this->messageNumber);
		
		$from = $overview->from;
		foreach ($from as $object) {
			@$this->fromname =iconv_mime_decode($object->personal,0,"UTF-8");
			$this->fromaddress = $object->mailbox . "@" . $object->host;
		}
		
		$this->subject = iconv_mime_decode($overview->subject,0,"UTF-8");
		
	}
	
	// fetch email body	
	public function fetch() {
	
		$structure = @imap_fetchstructure($this->connection, $this->messageNumber);
		
		if(!$structure) {
		
			return false;
		
		} else {
		
			$myobj = get_object_vars($structure);
		
			if(isset($myobj['parts'])){
			
			$this->recurse($structure->parts);
			
			} else{
			
			$this->norecurse($structure);
			
			}
		
			return true;
		
		}
		
	}
		
	public function norecurse($structure) {
		
		$body=imap_body($this->connection, $this->messageNumber);
		
		//decode if quoted-printable
		if ($structure->encoding==4) { 
		
			$body=quoted_printable_decode($body);
		
		} 
		
		//PROCESSING
		if (strtoupper($structure->subtype)=='PLAIN') {
		
			$this->bodyPlain .= nl2br($body);
		
		} else if (strtoupper($structure->subtype)=='HTML') {
			
			$this->bodyHTML .= $body;
		
		}
		
	}
	
	public function recurse($messageParts, $prefix = '', $index = 1, $fullPrefix = true) {

		foreach($messageParts as $part) {
			
			$partNumber = $prefix . $index;
						
			if($part->type == 0) {
				if($part->subtype == 'PLAIN') {
					$this->bodyPlain .= $this->getPart($partNumber, $part->encoding);
				}
				else {
				
					$this->bodyHTML .= $this->getPart($partNumber, $part->encoding);
				}
			}
			elseif($part->type == 2) {
				$msg = new EmailMessage($this->connection, $this->messageNumber);
				$msg->getAttachments = $this->getAttachments;
				$msg->recurse($part->parts, $partNumber.'.', 0, false);
				$this->attachments[] = array(
					'type' => $part->type,
					'subtype' => $part->subtype,
					'filename' => '',
					'data' => $msg,
					'inline' => false,
				);
			}
			elseif(isset($part->parts)) {
				if($fullPrefix) {
					$this->recurse($part->parts, $prefix.$index.'.');
				}
				else {
					$this->recurse($part->parts, $prefix);
				}
			}
			elseif($part->type > 2) {
				if(isset($part->id)) {
					$id = str_replace(array('<', '>'), '', $part->id);
					$this->attachments[$id] = array(
						'type' => $part->type,
						'subtype' => $part->subtype,
						'filename' => $this->getFilenameFromPart($part),
						'data' => $this->getAttachments ? $this->getPart($partNumber, $part->encoding) : '',
						'inline' => true,
					);
				}
				else {
					$this->attachments[] = array(
						'type' => $part->type,
						'subtype' => $part->subtype,
						'filename' => $this->getFilenameFromPart($part),
						'data' => $this->getAttachments ? $this->getPart($partNumber, $part->encoding) : '',
						'inline' => false,
					);
				}
			}
			
			$index++;
			
		}
		
	}
	
	function getPart($partNumber, $encoding) {

		$data = imap_fetchbody($this->connection, $this->messageNumber, $partNumber);
		switch($encoding) {
			case 0: return $data; // 7BIT
			case 1: return $data; // 8BIT
			case 2: return $data; // BINARY
			case 3: return base64_decode($data); // BASE64
			case 4: return quoted_printable_decode($data); // QUOTED_PRINTABLE
			case 5: return $data; // OTHER
		}


	}
	
	function getFilenameFromPart($part) {

		$filename = '';

		if($part->ifdparameters) {
			foreach($part->dparameters as $object) {
				if(strtolower($object->attribute) == 'filename') {
					$filename = $object->value;
				}
			}
		}

		if(!$filename && $part->ifparameters) {
			foreach($part->parameters as $object) {
				if(strtolower($object->attribute) == 'name') {
					$filename = $object->value;
				}
			}
		}

		return $filename;

	}

}