<?php
ob_start();
// prefix with dot to allow subdomains
session_set_cookie_params(12600, '/');
session_start();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>Acorn Aid Admin</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black">
<meta name="mobile-web-app-capable" content="yes">

<link rel="shortcut icon" href="../img/favicon/favicon.ico" />
<link rel="apple-touch-icon" sizes="57x57" href="../img/favicon/apple-touch-icon-57x57.png" />
<link rel="apple-touch-icon" sizes="114x114" href="../img/favicon/apple-touch-icon-114x114.png" />
<link rel="apple-touch-icon" sizes="72x72" href="../img/favicon/apple-touch-icon-72x72.png" />
<link rel="apple-touch-icon" sizes="144x144" href="../img/favicon/apple-touch-icon-144x144.png" />
<link rel="apple-touch-icon" sizes="60x60" href="../img/favicon/apple-touch-icon-60x60.png" />
<link rel="apple-touch-icon" sizes="120x120" href="../img/favicon/apple-touch-icon-120x120.png" />
<link rel="apple-touch-icon" sizes="76x76" href="../img/favicon/apple-touch-icon-76x76.png" />
<link rel="apple-touch-icon" sizes="152x152" href="../img/favicon/apple-touch-icon-152x152.png" />
<link rel="icon" type="image/png" href="../img/favicon/favicon-196x196.png" sizes="196x196" />
<link rel="icon" type="image/png" href="../img/favicon/favicon-160x160.png" sizes="160x160" />
<link rel="icon" type="image/png" href="../img/favicon/favicon-96x96.png" sizes="96x96" />
<link rel="icon" type="image/png" href="../img/favicon/favicon-16x16.png" sizes="16x16" />
<link rel="icon" type="image/png" href="../img/favicon/favicon-32x32.png" sizes="32x32" />
<meta name="msapplication-TileColor" content="#659900" />
<meta name="msapplication-TileImage" content="../img/favicon/mstile-144x144.png" />
<meta name="msapplication-config" content="../img/favicon/browserconfig.xml" />

<link href="../style/index.css" rel="stylesheet" type="text/css" />
</head>

<body>
<?php
error_reporting(E_ALL ^ E_NOTICE);

// include functions
include '../config/functions.php';

$loguid = aa_mysqli_escape($_SESSION["acornaid_user"]);

// select language file from log in
if (!isset($_SESSION['lang'])) {
	$langfile = get_settings("Langauge").'.php';
} else {
	$langfile = $_SESSION['lang'].'.php';
}

// include selected langauge file
include '../langauge/'.$langfile;

// database connect for all pages
$db = db_connect();
$redirect_page = get_settings("Redirect_Page");

// if already logged in
if(isset($_SESSION["acornaid_user"])) {
	header('Location: '.$redirect_page);
}

// if logon form is submitted
if (isset($_POST["logon"])) {
	// set form vairables
	// trim and escape use input
	$user = form_field_clean($_POST['user'], TRUE);
	$pass = form_field_clean(hash('sha256', $_POST['pass']), TRUE);
	
	$_SESSION["lang"] = $_POST['lang'];
		
	$u_query = mysqli_query($db, "SELECT UID,User_ID,Pwd,Role FROM $mysql_users WHERE User_ID = '$user' AND Pwd = '$pass'");
	$u_on = mysqli_num_rows($u_query);
		
	// if username and password match set admin username and password
	if ($u_on >= 1) {
		
		$sessionid = session_id();
		
		$user = mysqli_fetch_array($u_query);
		$now = aa_mysqli_escape(timezone_time());
		mysqli_query($db, "UPDATE $mysql_users SET Session_ID = '".$sessionid."', Last_Logon = '$now' WHERE UID = ".aa_mysqli_escape($user["UID"])."");
		
		// set variables for log on session
		$_SESSION["acornaid_user"] = $user["UID"];
		
		// redirect to selected page
		header('Location: '.$redirect_page);

	} else {
		
		// if username and password incorrect then show error
		$logon_error = "<span class=\"error\">".$lang['index-error']."</span>";
				
	}
	
}
?>
<div class="outer">
    <div class="middle">
        <div id="aa-form-div">
        <div class="inner-padding">
        	
            <h1><?php echo get_settings('Company_Name'); ?></h1>
            <form id="form1" name="form1" method="post" action="<?php echo $_SERVER["PHP_SELF"]; ?>">
            <table>
            <tr>
                <td colspan="2"><?php if (isset($logon_error)) { echo $logon_error; } ?></td>
			</tr>
            <tr>
                <td><label><?php echo $lang['index-username']; ?></label></td>
                <td><input  autocomplete="off" name="user" type="text" autofocus="autofocus" placeholder="<?php echo $lang['index-username']; ?>" /></td>
			</tr>
            <tr>
                <td><label><?php echo $lang['index-password']; ?></label></td>
                <td><input  autocomplete="off" name="pass" type="password" placeholder="<?php echo $lang['index-password']; ?>"/></td>
			</tr>
            <tr>
                <td><label><?php echo $lang['index-langauge']; ?></label></td>
                <td><?php
            select_langauge();
            ?>
            </select></td>
			</tr>
            <tr>
                <td class="aa-text-right" colspan="2"><a href="pwreset.php"><?php echo $lang['index-forgotpwd']; ?></a> <input name="logon" type="submit" value="<?php echo $lang['index-login']; ?>" /></td>
			</tr>
            </table>           

            </form>
            
        </div>
        </div>
        
    </div>
</div>
</body>
</html>
<?php
ob_end_flush();
?>