<?php

$uid = @$loguid;
// unset csv content to prevent data adding on each time
unset($_SESSION["csv_header"], $_SESSION["csv_body"]);

if (isset($_POST["action_report"])) {
	
	$report_type = $_POST["report_type"];
	$report_groupby = $_POST["report_groupby"];
	$report_set_period = $_POST["report_set_period"];
	$report_graphic = @$_POST["rep_graphic"];
	$report_period_from = aa_mysqli_escape($_POST["rep_period_from"]);
	$report_period_to = aa_mysqli_escape($_POST["rep_period_to"]);

	// set the date for mysql search
	switch ($report_set_period) {
		case "today":
			$report_date_from = date("Y-m-d 00:00:00",strtotime("today"));
			$report_date_to = date("Y-m-d 23:59:59",strtotime("today"));
			break;
		case "yesterday":
			$report_date_from = date("Y-m-d 00:00:00",strtotime("yesterday"));
			$report_date_to = date("Y-m-d 23:59:59",strtotime("yesterday"));
			break;
		case "this_week":
			$report_date_from = date("Y-m-d",strtotime("monday this week"));
			$report_date_to = date("Y-m-d 23:59:59",strtotime("today"));
			break;
		case "last_week":
			$report_date_from = date("Y-m-d 00:00:00",strtotime("monday last week"));
			$report_date_to = date("Y-m-d 23:59:59",strtotime("sunday last week"));
			break;
		case "this_month":
			$report_date_from = date("Y-m-d 00:00:00",strtotime("first day of this month"));
			$report_date_to = date("Y-m-d 23:59:59",strtotime("today"));
			break;
		case "last_month":
			$report_date_from = date("Y-m-d 00:00:00",strtotime("first day of last month"));
			$report_date_to = date("Y-m-d 23:59:59",strtotime("last day of last month"));
			break;	
		case "custom":
			$report_date_from = $_POST["rep_period_from"];
			$report_date_to = $_POST["rep_period_to"];
			break;
		}
	
	// check if dates are entered for custom dates	
	if ($report_set_period == "custom") {
	
		if (!($report_period_from && $report_period_to)) {

			$report_error = $lang['generic-error-inv-date'];
			
		}
		
	}
	
	if (!isset($report_error)) {
	
		if ($report_type == "ticket_summary" && $report_groupby == "Date") { // ticket summary by date
			
			$report_to_run = mysqli_query($db, "SELECT 
							c.datefield  AS DATE,
							t.Date_Added,
							COUNT(t.Status) AS Total,
							IFNULL(SUM(t.Status =  'Open' ),0) AS Open, 
							IFNULL(SUM(t.Status =  'Pending'),0) AS Pending, 
							IFNULL(SUM(t.Status =  'Paused'),0) AS Paused, 
							IFNULL(SUM(t.Status =  'Closed'),0) AS Closed
							FROM  $mysql_ticket AS t
							RIGHT JOIN calendar AS c ON (DATE(t.Date_Added) = c.datefield) 
							WHERE c.datefield
							BETWEEN '$report_date_from'
							AND '$report_date_to'
							GROUP BY DATE") or die(mysql_error());
								
		} else if ($report_type == "ticket_summary" && $report_groupby == "Agent") { // ticket summary by agent
		
			$report_to_run = mysqli_query($db, "SELECT 
							t.Owner,
							COUNT(Status) AS Total,
							SUM(t.Status =  'Open' ) AS Open, 
							SUM(t.Status =  'Pending' ) AS Pending, 
							SUM(t.Status =  'Paused' ) AS Paused, 
							SUM(t.Status =  'Closed' ) AS Closed,
							u.UID,
							(CASE WHEN t.Owner IS NULL THEN 'Unassigned' ELSE CONCAT(u.Fname, ' ' ,u.Lname) END) AS Owned
							FROM  $mysql_ticket AS t
							LEFT JOIN $mysql_users AS u ON t.Owner = u.UID
							WHERE Date_Added
							BETWEEN '$report_date_from'
							AND '$report_date_to'
							GROUP BY u.UID") or die(mysql_error());	
		
		} else if  ($report_type == "ticket_summary" && $report_groupby == "Group") { // ticket summary by group
		
			$report_to_run = mysqli_query($db, "SELECT 
							t.Cat_ID,
							COUNT(Status) AS Total,
							SUM(t.Status =  'Open' ) AS Open, 
							SUM(t.Status =  'Pending' ) AS Pending, 
							SUM(t.Status =  'Paused' ) AS Paused, 
							SUM(t.Status =  'Closed' ) AS Closed,
							c.Cat_ID,
							c.Category
							FROM  $mysql_ticket AS t
							LEFT JOIN $mysql_categories AS c ON t.Cat_ID = c.Cat_ID
							WHERE Date_Added
							BETWEEN '$report_date_from'
							AND '$report_date_to'
							GROUP BY c.Cat_ID") or die(mysql_error());
							
		} else if ($report_type == "group_load") {
		
			$report_to_run = mysqli_query($db, "SELECT
							t.Cat_ID, 
							COUNT( * ) AS Total,
							c.Cat_ID,
							c.Category
							FROM $mysql_ticket AS t
							LEFT JOIN $mysql_categories AS c ON t.Cat_ID = c.Cat_ID
							WHERE Date_Added
							BETWEEN '$report_date_from'
							AND '$report_date_to'				
							GROUP BY t.Cat_ID") or die(mysql_error());							

		} else if ($report_type == "customer_satisfaction") {

			$report_to_run = mysqli_query($db, "SELECT Date_Added,Feedback, COUNT(Feedback) AS rating 
							FROM $mysql_ticket 
							WHERE Date_Added
							BETWEEN '$report_date_from'
							AND '$report_date_to' AND Feedback IS NOT NULL 
							GROUP BY Feedback") or die(mysql_error());		
							
		} else if ($report_type == "source_type") {
		
			$report_to_run = mysqli_query($db, "SELECT Date_Added,Type, COUNT(Type) AS Total 
							FROM $mysql_ticket 
							WHERE Date_Added
							BETWEEN '$report_date_from'
							AND '$report_date_to'
							GROUP BY Type") or die(mysql_error());		

		} else if ($report_type == "time_spent" && $report_groupby == "Date") {
		
			$report_to_run = mysqli_query($db, "SELECT 
							c.datefield  AS DATE,
							t.Date_Added,
							SUM(tu.Update_Time) AS Total
							FROM  ticket AS t
							RIGHT JOIN calendar AS c ON (DATE(t.Date_Updated) = c.datefield) 
							LEFT JOIN ticket_updates AS tu ON t.ID = tu.Ticket_ID
							WHERE c.datefield
							BETWEEN '$report_date_from'
							AND '$report_date_to'							
							GROUP BY DATE") or die(mysql_error());
		
		} else if ($report_type == "time_spent" && $report_groupby == "Agent") {
		
			$report_to_run = mysqli_query($db, "SELECT 
							t.Owner,
							SUM(tu.Update_Time) AS Total,
							(CASE WHEN t.Owner IS NULL THEN 'Unassigned' ELSE CONCAT(u.Fname, ' ' ,u.Lname) END) AS Owned
							FROM ticket AS t
							LEFT JOIN $mysql_ticket_updates AS tu ON t.ID = tu.Ticket_ID
							LEFT JOIN $mysql_users AS u ON tu.Update_By = u.UID
							WHERE Date_Updated
							BETWEEN '$report_date_from'
							AND '$report_date_to'
							GROUP BY u.UID") or die(mysql_error());
		
		} else if ($report_type == "time_spent" && $report_groupby == "Group") {
		
			$report_to_run = mysqli_query($db, "SELECT 
							c.Category,
							SUM(tu.Update_Time) AS Total
							FROM  ticket AS t
							LEFT JOIN ticket_updates AS tu ON t.ID = tu.Ticket_ID
							LEFT JOIN groups AS c ON t.Cat_ID = c.Cat_ID
							WHERE Date_Updated
							BETWEEN '$report_date_from'
							AND '$report_date_to'							
							GROUP BY c.Cat_ID") or die(mysql_error());
		
		}
		
		// get number of records
		$report_results = mysqli_num_rows($report_to_run);	
	
	}

}
?>

<div id="body-left" class="body-20 border-color clear">

    <div class="pad10">
    <p class="hide-desktop"><a href="#" id="open-filter"><i class="fa fa-bar-chart-o"></i></a></p>
    
    <p class="hide-mobile"><?php echo $lang['rep-filter']; ?></p>
    
    </div>

    <div id="inner-body-left">
        <div class="pad10">
    	<div class="hide-desktop" id="filter-close"><p><i class="fa fa-arrow-circle-o-right"></i></p></div>    
        <form name="reporting" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
        <label><?php echo $lang['rep-report']; ?></label>
        <select name="report_type" id="report_type">
        <?php
        $reports = array("ticket_summary" => $lang['rep-dd-ts'], 
                        "group_load" => $lang['rep-dd-gl'],
                        "customer_satisfaction" => $lang['rep-dd-cs'],
						"source_type" => $lang['rep-dd-st'],
						"time_spent" => $lang['rep-dd-tt']);
       
        foreach($reports as $key => $value) {
        
            if($report_type == $key) {
            
                echo "<option value=\"".$key."\" selected=\"selected\">".$value."</option>";
            
            } else {
                
                echo "<option value=\"".$key."\">".$value."</option>";
            
            }
            
        }
        ?>
        </select>
        
        <div id="report_groupby_div">
        <label><?php echo $lang['report-groupby']; ?></label>
        <select name="report_groupby" id="report_groupby">
        <?php
        $groupby = array("Agent" => $lang['report-groupby-agent'],
						 "Date" => $lang['report-groupby-date'],
                         "Group" => $lang['report-groupby-group']);
       
        foreach($groupby as $key => $value) {
        
            if($report_groupby == $key) {
            
                echo "<option value=\"".$key."\" selected=\"selected\">".$value."</option>";
            
            } else {
                
                echo "<option value=\"".$key."\">".$value."</option>";
            
            }
            
        }
        ?>
        </select>
        </div>
        
        <label><?php echo $lang['rep-period']; ?></label>
        <select name="report_set_period" id="report_set_period">
        <?php
    	$reports = array("today" => $lang['tickets-dateadd-today'], 
						"yesterday" => $lang['tickets-dateadd-yesterday'],
						"this_week" => $lang['tickets-dateadd-thisweek'],		
						"last_week" => $lang['tickets-dateadd-lastweek'],
						"this_month" => $lang['tickets-dateadd-thismonth'],		
						"last_month" => $lang['tickets-dateadd-lastmonth'],
						"custom" => $lang['rep-date-dd-cust']);
			                        
        foreach($reports as $key => $value) {
        
            if($report_set_period == $key) {
            
                echo "<option value=\"".$key."\" selected=\"selected\">".$value."</option>";
            
            } else {
                
                echo "<option value=\"".$key."\">".$value."</option>";
            
            }
            
        }
        ?>
        </select>
        
        <div id="report_custom_dates">
        <?php
        if (isset($report_error)) {
        ?>
        <span class="error"><?php echo $report_error; ?></span>
        <?php
        }
        ?>
        <label><?php echo $lang['rep-period-from']; ?></label>
        <input id="rep_period_from" name="rep_period_from" type="text" value="<?php if (isset($_POST["rep_period_from"])) { echo $_POST["rep_period_from"]; } ?>" />
        
        <label><?php echo $lang['rep-period-to']; ?></label>
        <input id="rep_period_to" name="rep_period_to" type="text" value="<?php if (isset($_POST["rep_period_to"])) { echo $_POST["rep_period_to"]; } ?>" />
        </div>
        
        <label><?php echo $lang['rep-graphic']; ?></label>
        <input name="rep_graphic" type="checkbox" id="rep_graphic" <?php if (isset($report_graphic)) { echo "checked=\"checked\""; } ?> />
        
        <p><input name="action_report" type="submit" value="<?php echo $lang['rep-report']; ?>" /></p>
        <p><input  name="action_reset" type="submit" value="<?php echo $lang['rep-reset']; ?>" /></p>
        
        </form>
        
        
        <?php
        // Edit report type to create title and graph
        $report_title = ucwords(str_replace("_"," ",$report_type));
        
        // Strip string to get first word for title
        $report_key = strstr($report_title," ",true);
        
        switch ($report_type) {
            case "ticket_summary";
                $report_tr_head = "<tr class=\"link-color\">
                <td class=\"border-color\" width=\"25%\" >".$report_groupby."</td>
                <td class=\"border-color\" width=\"15%\" >".$lang['rep-total']."</td>
                <td class=\"border-color\" width=\"15%\" >".$lang['tickets-status-open']."</td>
                <td class=\"border-color\" width=\"15%\" >".$lang['tickets-status-pending']."</td>
                <td class=\"border-color\" width=\"15%\" >".$lang['tickets-status-paused']."</td>
                <td class=\"border-color\" width=\"15%\" >".$lang['tickets-status-closed']."</td>
                </tr>";
                $_SESSION["csv_header"] = $report_key.",".$lang['rep-total'].",".$lang['tickets-status-open'].",".$lang['tickets-status-pending'].",".$lang['tickets-status-paused'].",".$lang['tickets-status-closed']."\n";
                break;
                
            case "group_load":
			case "source_type":
                $report_tr_head = "<tr class=\"link-color\">
                <td class=\"border-color\" width=\"50%\" >".$report_key."</td>
                <td class=\"border-color\" width=\"50%\" >".$lang['rep-total']."</td>
                </tr>";
                $_SESSION["csv_header"] = $report_key.",".$lang['rep-total']."\n";	
                break;
							
			case "time_spent":		
                $report_tr_head = "<tr class=\"link-color\">
                <td class=\"border-color\" width=\"50%\" >".$report_groupby."</td>
                <td class=\"border-color\" width=\"50%\" >".$lang['rep-total']."</td>
                </tr>";
                $_SESSION["csv_header"] = $report_key.",".$lang['rep-total']."\n";	
                break;
                
            case "customer_satisfaction":
                $report_tr_head = "<tr class=\"link-color\">
                <td class=\"border-color\" width=\"50%\" >".$lang['rep-feedback']."</td>
                <td class=\"border-color\" width=\"50%\" >".$lang['rep-total']."</td>
                </tr>";		
                $_SESSION["csv_header"] = $lang['rep-feedback'].",".$lang['rep-total']."\n";	
                break;			
                
            }
            
        ?>
        
        </div>
    </div>
    
</div>
<div id="body-middle" class="body-80">
<div class="pad10">
<?php
if (isset($_POST["action_report"])) {
?>
<p class="pagetitle"><?php echo $lang['rep-report']; ?></p>
<a name="reportresults"></a>
<p><?php echo $report_title; ?> - <?php echo date("D jS M Y", strtotime($report_date_from))." - ".date("D jS M Y", strtotime($report_date_to)); ?></p>
<?php

$_SESSION["csv_filename"] = $report_title."-".$report_date_from."-".$report_date_to;
if ($report_results == 0) {
	
	echo "<p><span class=\"error\">".$lang['rep-no-data']."</span></p>";	
	
} else {
	
?>
<p><strong><a href="report-export.php?export_report_csv=yes"><i class="fa fa-download"></i> <?php echo $lang['rep-download']; ?></a></strong></p>
<table class="table_header" width="100%">
<colgroup>
<col />
<col />
<col />
<col />
<col />
<col />
</colgroup>

	<thead>
	<?php
	echo $report_tr_head;
	?>
	</thead>
<tbody>
<?php
// while loop to get the number of feedback ratings by date added
while ($rating_total = mysqli_fetch_array($report_to_run)) {

	$total += $rating_total["rating"];
	
}
	
// free statement to be used again
mysqli_data_seek($report_to_run, 0);

while ($report = @mysqli_fetch_array($report_to_run)) {

// generate string for google charts report
switch ($report_type) {
	case "ticket_summary":
		if ($report_groupby == "Date") {
			$data_name = $report["DATE"];
		} else if ($report_groupby == "Group") {
			$data_name = $report["Category"];
		} else if ($report_groupby == "Agent") {
			$data_name = $report["Owned"];
		}
		// create string for graph data
		$graph_tickets_by_group2 .= "['".$data_name."' , ".$report["Total"].", ".$report["Open"].", ".$report["Pending"].", ".$report["Paused"].", ".$report["Closed"].",],";
		$report_tr_body = $report_summary;
		break;	
	case "group_load":
		$data_name = $report["Category"];
		// create string for graph data
		$graph_tickets_by_group2 .= "['".$data_name."' , ".$report["Total"]."],";
		$report_tr_body = $report_load;
		break;
	case "time_spent":
		if ($report_groupby == "Date") {
			$data_name = $report["DATE"];
		} else if ($report_groupby == "Group") {
			$data_name = $report["Category"];
		} else if ($report_groupby == "Agent") {
			$data_name = $report["Owned"];
		}
		// create string for graph data
		$graph_tickets_by_group2 .= "['".$data_name."' , ".$report["Total"]."],";
		$report_tr_body = $report_load;
		break;
	case "customer_satisfaction":
					
		// rename rows based on value
		switch ($report["Feedback"]) {
			case 0:
			$data_name = $lang['ticket-rate-neg'];
			break;
			case 1:
			$data_name = $lang['ticket-rate-neu'];
			break;
			case 2:
			$data_name = $lang['ticket-rate-p'];
			break;
			}
		$graph_tickets_by_group2 .= "['".$data_name."' , ".$report["rating"]."],";								
		// break report type
		break;	
	case "source_type":
		$data_name = $report["Type"];
		// create string for graph data
		$graph_tickets_by_group2 .= "['".$data_name."' , ".$report["Total"]."],";
		$report_tr_body = $report_load;
		break;
				
	}

switch ($report_type) {
	case "ticket_summary";
		$report_tr_body = "<tr>
		<td class=\"border-color\" data-title=\"".decode_entities($data_name)."\">".decode_entities($data_name)."</td>
		<td class=\"border-color\" data-title=\"".$report["Total"]."\">".$report["Total"]."</td>
		<td class=\"border-color\" data-title=\"".$report["Open"]."\">".$report["Open"]."</td>
		<td class=\"border-color\" data-title=\"".$report["Pending"]."\">".$report["Pending"]."</td>
		<td class=\"border-color\" data-title=\"".$report["Paused"]."\">".$report["Paused"]."</td>
		<td class=\"border-color\" data-title=\"".$report["Closed"]."\">".$report["Closed"]."</td>
		</tr>";
		$_SESSION["csv_body"] .= $data_name.",".$report["Total"].",".$report["Open"].",".$report["Pending"].",".$report["Paused"].",".$report["Closed"]."\n";
		break;
		
	case "group_load":
	case "source_type":
		$report_tr_body = "<tr>
		<td class=\"border-color\" data-title=\"".$data_name."\">".$data_name."</td>
		<td class=\"border-color\" data-title=\"".$report["Total"]."\">".$report["Total"]."</td>
		</tr>";
		$_SESSION["csv_body"] .= $data_name.",".$report["Total"]."\n";			
		break;

	case "time_spent":
		$hours = floor($report["Total"] / 60);
		$mins = sprintf("%02s", ($report["Total"] % 60));
		$report_tr_body = "<tr>
		<td class=\"border-color\" data-title=\"".$data_name."\">".$data_name."</td>
		<td class=\"border-color\" data-title=\"".$hours.":".$mins."\">".$hours.":".$mins."</td>
		</tr>";
		$_SESSION["csv_body"] .= $data_name.",".$hours.":".$mins."\n";			
		break;
	
	case "customer_satisfaction":
		// round to 2 decimel places.
		$rating_percentage = round($report["rating"] / $total * 100, 2);
		$report_tr_body = "<tr>
		<td class=\"border-color\" data-title=\"".$data_name."\">".$data_name."</td>
		<td class=\"border-color\" data-title=\"Total\">".$rating_percentage."%</td>
		</tr>";
		$_SESSION["csv_body"] .= $data_name.",".$rating_percentage."%\n";			
		break;		
		
	}		
	
	// print tr row depending on report
	echo $report_tr_body;

// end while loop
}

// strip last comma off data
$graph_data = rtrim($graph_tickets_by_group2, ",");
?>
</tbody>
</table>
<br />
<script>
	google.load("visualization", "1", {packages:["corechart"]});
	google.setOnLoadCallback(drawLineChart);
	function drawLineChart() {
	var data = google.visualization.arrayToDataTable([
	  ['Ticket', 'Total', 'Open', 'Pending', 'Paused', 'Closed'],
			<?php echo $graph_data; ?>
	]);
	
	var options = {
			chartArea: {'width': '75%', 'height': '75%', },
			legend: { position: 'bottom' },
			hAxis: { gridlines: { color: "#EEE" }, baselineColor: '#EEE', textStyle: { color: '#666' } },		
			vAxis: { gridlines: { color: "#EEE" }, baselineColor: '#EEE', textStyle: { color: '#666' } }
	};
	
	var chart = new google.visualization.LineChart(document.getElementById('linechart_div'));
	chart.draw(data, options);
			
	}
	
	
	// chart for agent summary
	google.load("visualization", "1", {packages:["corechart"]});
	  google.setOnLoadCallback(drawChart);
	  function drawChart() {
		var data = google.visualization.arrayToDataTable([
		  ['Year', 'Total', 'Open', 'Pending', 'Paused', 'Closed' ],
			<?php echo $graph_data; ?>
			]);

		var options = {
		  chartArea: {'width': '75%', 'height': '75%'},
		  title: '<?php echo $report_title; ?>',
		  hAxis: {title: '<?php echo $report_key; ?>', titleTextStyle: {color: 'red'}},
		  vAxis: {format: '0'}
		};

		var chart = new google.visualization.ColumnChart(document.getElementById('chart_div'));
		chart.draw(data, options);
		
		
	  }
	  
	  // pie chart
	  google.load("visualization", "1", {packages:["corechart"]});
	  google.setOnLoadCallback(drawPieChart);
	  function drawPieChart() {
		var data = google.visualization.arrayToDataTable([
		  ['Task', 'Hours per Day'],
			<?php echo $graph_data; ?>
		]);

		var options = {
		  title: '<?php echo $report_title; ?>'
		};

		var chart = new google.visualization.PieChart(document.getElementById('piechart'));
		chart.draw(data, options);
				  
	  }
	  
		  
</script>
<br />
<?php
if (isset($report_graphic)) {
?>
<?php
switch (true) {
	case ($report_type == "ticket_summary" && $report_groupby == "Date"): // if ticket summary and group by date
		echo "<div id=\"linechart_div\" style=\"width: 100%; height: 500px;\"></div>";
		break;
	case ($report_type == "ticket_summary" && $report_groupby != "Date"): // if ticket summary and group by agent or group
		echo "<div id=\"chart_div\" style=\"width: 100%; height: 500px;\"></div>";
		break;
	case "group_load":
	case "customer_satisfaction":
	case "source_type":
		echo "<div id=\"piechart\" style=\"width: 100%; height: 500px;\"></div>";
		break;
	case ($report_type == "time_spent" && $report_groupby == "Date"):
		echo "<div id=\"linechart_div\" style=\"width: 100%; height: 500px;\"></div>";
		break;
	case ($report_type == "time_spent" && $report_groupby != "Date"):
		echo "<div id=\"piechart\" style=\"width: 100%; height: 500px;\"></div>";
		break;		
	}
?>
<?php
// end if report checkbox ticked
}

// end if else for if results is greater than 0
}
 
// end if report run
echo "<div id='png'></div>";

}
?>
</div>
</div>
