<?php

$uid = @$loguid;
$date_format = get_settings('Date_Format');


// unset all search session variables but not the logon sessions
function unset_filter() {
	unset($_SESSION["search_str"],$_SESSION["adv_s_tid"],$_SESSION["adv_s_subject"],
	$_SESSION["adv_s_msg"],$_SESSION["adv_s_cust"],$_SESSION["adv_s_group"],
	$_SESSION["adv_s_priority"],$_SESSION["adv_s_status"],$_SESSION["adv_s_owner"],
	$_SESSION["adv_s_dateadd_from"],$_SESSION["adv_s_dateadd_to"],
	$_SESSION["adv_s_dateup_from"],$_SESSION["adv_s_dateup_to"],
	$_SESSION["adv_s_dateclosed_from"],$_SESSION["adv_s_dateclosed_to"],
	$_SESSION["saved_search"],$_SESSION["qs_input"]);
}

// function to create mysql search string. used on pagination count and search statement
function create_search_str () {
	
	// clear existing search before generating new search string
	unset_filter();

	$_SESSION["adv_s_tid"] = $_POST["adv_s_tid"];
	$_SESSION["adv_s_subject"] = $_POST["adv_s_subject"];
	$_SESSION["adv_s_msg"] = $_POST["adv_s_msg"];
	$_SESSION["adv_s_cust"] = $_POST["adv_s_cust"];
	$_SESSION["adv_s_group"] = $_POST["adv_s_group"];
	$_SESSION["adv_s_priority"] = $_POST["adv_s_priority"];
	$_SESSION["adv_s_status"] = $_POST["adv_s_status"];
	$_SESSION["adv_s_owner"] = $_POST["adv_s_owner"];
	$_SESSION["adv_s_dateadd_from"] = $_POST["adv_s_dateadd_from"];
	$_SESSION["adv_s_dateadd_to"] = $_POST["adv_s_dateadd_to"];
	$_SESSION["adv_s_dateup_from"] = $_POST["adv_s_dateup_from"];
	$_SESSION["adv_s_dateup_to"] = $_POST["adv_s_dateup_to"];
	$_SESSION["adv_s_dateclosed_from"] = $_POST["adv_s_dateclosed_from"];
	$_SESSION["adv_s_dateclosed_to"] = $_POST["adv_s_dateclosed_to"];
	
	// Place all variables into an array
	$search = array("t.ID" => $_SESSION["adv_s_tid"], 
					"t.Subject" => $_SESSION["adv_s_subject"], 
					"t.Message" => $_SESSION["adv_s_msg"], 
					"t.User" => $_SESSION["adv_s_cust"], 
					"t.Cat_ID" => $_SESSION["adv_s_group"],
					"t.Level_ID" => $_SESSION["adv_s_priority"], 
					"t.Status" => $_SESSION["adv_s_status"],
					"t.Owner" => $_SESSION["adv_s_owner"],
					"t.Date_Added" => $_SESSION["adv_s_dateadd_from"],
					"t.Date_Updated" => $_SESSION["adv_s_dateup_from"],
					"t.Date_Closed" => $_SESSION["adv_s_dateclosed_from"]														
					);
	
		// Loop through variables to create mysql WHERE string
		foreach($search as $key => $result) {
			
			// escape value of each search
			$result = aa_mysqli_escape($result);
		
			if ($result != "") {
				
				if ($key == "t.Owner") {
					
					// use IS NULL if ticket unassigned
					$search_str .= "(t.Owner LIKE  '%".$result."%' OR t.Owner IS NULL) AND";
				
				} else if ($key == "t.Date_Added") {
					
					$search_str .= "(t.Date_Added BETWEEN '".$_SESSION["adv_s_dateadd_from"]."' AND '".$_SESSION["adv_s_dateadd_to"]."') AND ";
				
				} else if ($key == "t.Date_Updated") {
					
					$search_str .= "(t.Date_Updated BETWEEN '".$_SESSION["adv_s_dateup_from"]."' AND '".$_SESSION["adv_s_dateup_to"]."') AND ";
					
				} else if ($key == "t.Date_Closed") {
					
					$search_str .= "(t.Date_Closed BETWEEN '".$_SESSION["adv_s_dateclosed_from"]."' AND '".$_SESSION["adv_s_dateclosed_to"]."') AND ";
				
				} else {
					
					@$search_str .= "(".$key." LIKE '%".$result."%') AND ";
				
				}
				
				@$result_str .= $result. " and ";
												
			}
			
		}
	
	$search_str = rtrim($search_str, " AND ");
	$result_str = rtrim($result_str, " and ");	
	
	// return search string to be used in MYSQL statements		
	return array ($search_str, $result_str);

}

// return search values into search form
function searched_values ($var1) {
	if (isset($var1)) {
		echo $var1;
	} else {
		echo "";
	}
}

// if advanced search used
if (isset($_POST["action_reset"])) {

	// clear existing search before generating new search string
	unset_filter();

	header('Location: '.$_SERVER['REQUEST_URI']);

}

// if advanced search used
if (isset($_POST["action_search"])) {
	
	list($search_str, $qs_input) = create_search_str();
	
	// save input for display and search for dodging between pages
	$_SESSION["qs_input"] = $qs_input;
	$_SESSION["saved_search"] = $search_str;
	
	$sql_search = "SELECT
				t.ID, 
				t.Subject,
				t.User,
				t.Status,
				t.Type,				
				DATE_FORMAT(t.Date_Added, '$date_format') AS DateAdd,
				DATE_FORMAT(t.Date_Updated, '$date_format') AS DateUp,
				DATE_FORMAT(t.Date_Closed, '$date_format') AS DateClosed,								
				t.Cat_ID,
				CASE t.Cat_ID WHEN c.Cat_ID THEN c.Category ELSE NULL END Category,
				t.Level_ID,
				CASE t.Level_ID WHEN p.Level_ID THEN p.Level ELSE NULL END Priority,
				t.Owner,
				(CASE WHEN t.Owner IS NULL THEN 'Unassigned' ELSE CONCAT(u.Fname, ' ' ,u.Lname) END) AS Owned								
				FROM $mysql_ticket AS t
				LEFT JOIN $mysql_categories AS c ON t.Cat_ID = c.Cat_ID 
				LEFT JOIN $mysql_priorities AS p ON t.Level_ID = p.Level_ID 
				LEFT JOIN $mysql_users AS u ON t.Owner = u.UID
				WHERE $search_str
				ORDER BY t.Date_Added DESC";
				
$searched_tickets = mysqli_query($db, $sql_search) or die(mysql_error());				

// if quick search used
} else if (isset($_GET["search"])) {

	// clear existing search before generating new search string
	unset_filter();
	
	$qs_input = aa_mysqli_escape($_GET["search"]);
	$_SESSION["qs_input"] = $qs_input;

	$sql_search = "SELECT
				t.ID, 
				t.Subject,
				t.User,
				t.Status,
				t.Type,
				DATE_FORMAT(t.Date_Added, '$date_format') AS DateAdd,
				DATE_FORMAT(t.Date_Updated, '$date_format') AS DateUp,
				DATE_FORMAT(t.Date_Closed, '$date_format') AS DateClosed,								
				t.Cat_ID,
				CASE t.Cat_ID WHEN c.Cat_ID THEN c.Category ELSE NULL END Category,
				t.Level_ID,
				CASE t.Level_ID WHEN p.Level_ID THEN p.Level ELSE NULL END Priority,
				t.Owner,
				(CASE WHEN t.Owner IS NULL THEN 'Unassigned' ELSE CONCAT(u.Fname, ' ' ,u.Lname) END) AS Owned								
				FROM $mysql_ticket AS t
				LEFT JOIN $mysql_categories AS c ON t.Cat_ID = c.Cat_ID 
				LEFT JOIN $mysql_priorities AS p ON t.Level_ID = p.Level_ID 
				LEFT JOIN $mysql_users AS u ON t.Owner = u.UID
				WHERE (t.ID LIKE '%".$qs_input."%')
				OR (t.Subject LIKE '%".$qs_input."%')
				OR (t.User LIKE '%".$qs_input."%')								
				OR (t.Status LIKE '%".$qs_input."%')
				OR (c.Category LIKE '%".$qs_input."%')
				OR (p.Level LIKE '%".$qs_input."%')								
				OR (u.Fname LIKE '%".$qs_input."%')								
				OR (u.Lname LIKE '%".$qs_input."%')	
				OR (CONCAT(u.Fname, ' ' ,u.Lname) LIKE '%".$qs_input."%') 							
				OR (u.User_ID LIKE '%".$qs_input."%')
				ORDER BY t.Date_Added DESC";
										
$searched_tickets = mysqli_query($db, $sql_search) or die(mysql_error());

// if saved search
} else if (isset($_SESSION["saved_search"])) {
	
	$sql_search = "SELECT
				t.ID, 
				t.Subject,
				t.User,
				t.Status,
				t.Type,
				DATE_FORMAT(t.Date_Added, '$date_format') AS DateAdd,
				DATE_FORMAT(t.Date_Updated, '$date_format') AS DateUp,
				DATE_FORMAT(t.Date_Closed, '$date_format') AS DateClosed,				
				t.Cat_ID,
				CASE t.Cat_ID WHEN c.Cat_ID THEN c.Category ELSE NULL END Category,
				t.Level_ID,
				CASE t.Level_ID WHEN p.Level_ID THEN p.Level ELSE NULL END Priority,
				t.Owner,
				(CASE WHEN t.Owner IS NULL THEN 'Unassigned' ELSE CONCAT(u.Fname, ' ' ,u.Lname) END) AS Owned								
				FROM $mysql_ticket AS t
				LEFT JOIN $mysql_categories AS c ON t.Cat_ID = c.Cat_ID 
				LEFT JOIN $mysql_priorities AS p ON t.Level_ID = p.Level_ID 
				LEFT JOIN $mysql_users AS u ON t.Owner = u.UID
				WHERE $_SESSION[saved_search]
				ORDER BY t.Date_Added DESC";
				
	$searched_tickets = mysqli_query($db, $sql_search) or die(mysql_error());				

}

?>

  <div id="body-left" class="body-20 border-color clear">
    
    <div class="pad10">
    <p class="hide-desktop"><a href="#" id="open-filter"><i class="fa fa-search"></i></a></p>
    
    <p><span class="hide-mobile"><?php echo $lang['search-advanced']; ?></span></p>
    
    </div>
    
  <div id="inner-body-left">
  <div class="pad10">
      <div class="hide-desktop" id="filter-close"><p><i class="fa fa-arrow-circle-o-right"></i></p></div>    

    <form name="search_advanced" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
    
    <strong><?php echo $lang['tickets-ID']; ?></strong>
	<input id="adv_s_tid" name="adv_s_tid" type="text" value="<?php searched_values ($_SESSION["adv_s_tid"]); ?>" />
        
    <strong><?php echo $lang['search-subject']; ?></strong>
    <input id="adv_s_subject" name="adv_s_subject" type="text" value="<?php searched_values ($_SESSION["adv_s_subject"]); ?>" />
        
    <strong><?php echo $lang['search-msg']; ?></strong>
	<input id="adv_s_msg" name="adv_s_msg" type="text" value="<?php searched_values ($_SESSION["adv_s_msg"]); ?>" />
        
    <strong><?php echo $lang['search-cust']; ?></strong>
	<input id="adv_s_cust" name="adv_s_cust" type="text" value="<?php searched_values ($_SESSION["adv_s_cust"]); ?>" />
    
    <strong><?php echo $lang['tickets-group']; ?></strong>
    <select name="adv_s_group" id="adv_s_group">
    <option value="%"><?php echo $lang['search-any']; ?></option>		
    <?php
    $sel_cats = mysqli_query($db, "SELECT Cat_ID, Category FROM $mysql_categories WHERE Parent_ID IS NULL ORDER BY Category ASC");
    
    while ($cats = mysqli_fetch_array($sel_cats)) {
		
		if ($_SESSION["adv_s_group"] == $cats["Cat_ID"]) {

			echo "<option value=\"".$cats["Cat_ID"]."\" selected=\"selected\">".decode_entities($cats["Category"])."</option>";
        
		} else {
			
			echo "<option value=\"".$cats["Cat_ID"]."\">".decode_entities($cats["Category"])."</option>";
        
		}
		
    }
    
    ?>
    </select>
    
    
    <strong><?php echo $lang['tickets-status']; ?></strong>
    <?php
    
    $status_options = array("Open" => $lang['tickets-status-open'], "Pending" => $lang['tickets-status-pending'],
					 "Paused" => $lang['tickets-status-paused'], "Closed" => $lang['tickets-status-closed']);
    
    ?>
    
    <select name="adv_s_status" id="adv_s_status">
    <option value="%"><?php echo $lang['search-any']; ?></option>
    <?php
    
    foreach ($status_options as $opt_val => $opt_key) {
		
		if ($_SESSION["adv_s_status"] == $opt_val) {
        
        echo "<option value=\"".$opt_val."\" selected=\"selected\">".$opt_key."</option>";
        
		} else {
		
        echo "<option value=\"".$opt_val."\">".$opt_key."</option>";
			
		}
		
    }
    ?>
    </select>
    
    <strong><?php echo $lang['tickets-priority']; ?></strong>
    <select name="adv_s_priority" id="adv_s_priority">
    <option value="%"><?php echo $lang['search-any']; ?></option>		
    <?php
    $sel_level = mysqli_query($db, "SELECT Level_ID, Level FROM $mysql_priorities");
    
    while ($levels = mysqli_fetch_array($sel_level)) {

		if ($_SESSION["adv_s_priority"] == $levels["Level_ID"]) {

            echo "<option value=\"".$levels["Level_ID"]."\" selected=\"selected\">".decode_entities($levels["Level"])."</option>";
		
		} else {
			
            echo "<option value=\"".$levels["Level_ID"]."\">".decode_entities($levels["Level"])."</option>";
           
		}
    }
    
    ?>
    </select>
    
    <strong><?php echo $lang['tickets-owner']; ?></strong>
    <select name="adv_s_owner" id="adv_s_owner">
    <option value="%"><?php echo $lang['search-any']; ?></option>
    <?php
    $sel_users = mysqli_query($db, "SELECT UID,Fname,Lname FROM $mysql_users");
    
    while ($user = mysqli_fetch_array($sel_users)) {
		
		if($_SESSION["adv_s_owner"] == $user["UID"]) {

        	echo "<option value=\"".$user["UID"]."\" selected=\"selected\">".$user["Fname"]." ".$user["Lname"]."</option>";

		} else {
            
        	echo "<option value=\"".$user["UID"]."\">".$user["Fname"]." ".$user["Lname"]."</option>";
            
		}
			
    }
    
    ?>
    </select>

    <strong><?php echo $lang['search-dateaddfrom']; ?></strong>
	<input id="adv_s_dateadd_from" autocomplete="off" name="adv_s_dateadd_from" type="text" value="<?php searched_values ($_SESSION["adv_s_dateadd_from"]); ?>" />

    <strong><?php echo $lang['search-dateaddto']; ?></strong>
    <input id="adv_s_dateadd_to" autocomplete="off" name="adv_s_dateadd_to" type="text" value="<?php searched_values ($_SESSION["adv_s_dateadd_to"]); ?>" />

    <strong><?php echo $lang['search-dateupfrom']; ?></strong>
	<input id="adv_s_dateup_from" autocomplete="off" name="adv_s_dateup_from" type="text" value="<?php searched_values ($_SESSION["adv_s_dateup_from"]); ?>" />

    <strong><?php echo $lang['search-dateupto']; ?></strong>
	<input id="adv_s_dateup_to" autocomplete="off" name="adv_s_dateup_to" type="text" value="<?php searched_values ($_SESSION["adv_s_dateup_to"]); ?>" />

    <strong><?php echo $lang['search-closefrom']; ?></strong>
	<input id="adv_s_dateclosed_from" autocomplete="off" name="adv_s_dateclosed_from" type="text" value="<?php searched_values ($_SESSION["adv_s_dateclosed_from"]); ?>" />
    
    <strong><?php echo $lang['search-datecloseto']; ?></strong>
	<input id="adv_s_dateclosed_to" autocomplete="off" name="adv_s_dateclosed_to" type="text" value="<?php searched_values ($_SESSION["adv_s_dateclosed_to"]); ?>" />
    
    <p><input name="action_search" type="submit" value="<?php echo $lang['search-button-submit']; ?>" /></p>
    <p><input name="action_reset" type="submit" value="<?php echo $lang['search-button-reset']; ?>" /></p>
    </form>
  </div>
  </div>
  </div>
    
    <div id="body-middle" class="body-80">
    <?php
	if (isset($qs_input) || isset($_POST["action_search"]) || isset($_SESSION["saved_search"])) {

		$search_total = countsqlrows($sql_search);
	
		if($search_total > 0) {
		?>
        <div id="table_header">
        <div id="table_generic">
		<?php
		echo "<b>".$search_total."</b> ".$lang['search-results']." <span id=\"search_criterea\"></span>";
	
		?>
		</div>
		</div>
		<?php
		
			while ($ticket = @mysqli_fetch_array($searched_tickets)) {
			
			$user = decode_entities($ticket["User"]);
			$subject = decode_entities($ticket["Subject"]);
				
			switch ($ticket["Status"]) {
			case "Open":
				$row = "open";
				$td = "open";
				break;
			case "Pending":
				$row = "";		
				$td = "pending";		
				break;
			case "Paused":
				$row = "";		
				$td= "paused";
				break;
			case "Closed":
				$row = "";		
				$td = "closed";
				break;	
			default:
				$row = "";
				$td = "";
			}

			?>
            <div class="ticket" id="<?php echo $ticket["ID"]; ?>">
	        <div class="ticket_color <?php echo $td; ?>">&nbsp;</div>
                    
            <div class="ticket_search">
            <?php echo "<p class=\"pagetitle\"><strong>".highlight($qs_input, $subject)."</strong> <span class=\"detail\">".$lang['search-from']." ".highlight($qs_input, ucwords(strtolower($user)))."</span></p>
            <span class=\"detail\">
            <i style=\"margin-left:0px\" class=\"fa fa-plus-square\"></i> ".decode_entities(highlight($qs_input, aa_select_ticket_status_lang($ticket["Status"])))."
            <i class=\"fa fa-folder\"></i> ".decode_entities(highlight($qs_input, $ticket["Category"]))."
            <i class=\"fa fa-flag\"></i> ".decode_entities(highlight($qs_input, $ticket["Priority"]))." 
            <i class=\"fa fa-user\"></i> ".decode_entities(highlight($qs_input, $ticket["Owned"]))."
			".aa_select_ticket_type_lang($ticket['Type'])."</span>
			<p>
            <span><i style=\"margin-left:0px\" class=\"fa fa-calendar\"></i> ".$lang['search-added']." ".$ticket["DateAdd"]."</span>
            <span><i class=\"fa fa-calendar\"></i> ".$lang['search-updated']." ".$ticket["DateUp"]."</span>";

			if ($ticket["DateClosed"] != NULL) {
    		
				echo  "<span><i class=\"fa fa-calendar\"></i> ".$lang['search-closed']." ".$ticket["DateClosed"]."</span></p>";
	
            } else {
			
				echo "</p>";			
			
			}
			?>
            </div>
            <div class="ticket_numbers"><?php echo "<p>#".highlight($qs_input, $ticket["ID"]); ?></p></div>
            </div>
			<?php
			// end while loop
			}
		
		// end if total search is greater than 0	
		} else {
			?>
            <div id="table_header">
        	<div id="table_generic">
			<?php echo $lang['search-no-results']; ?> <span id="search_criterea"></span>
			</div>
            </div>
    		<?php
		}

	}
	?>
    </div>
