<script>
$(document).ready(function() {
	
	var tid = $('#tid').attr('tid');
	var uid = $('#tid').attr('uid');
	// turn collision detection on
	$.ajax({  
		url: "ajax.ticket_collision_on.php",
		data: {p_tid: tid, p_uid: uid},
		type: 'POST',  
		cache: false,
		async:false, 
		success: function(data) {		

			if (data != "") { // if error because another person already looking
				
				// disable editable content
				$(".editable").attr("contenteditable", "false");
				// disable all functionality with ticket page
				$("#form_background, #aa_ticket_error,  .collision_disable, .click_editable, .click_delete, #accept, #merge, #delete").hide();
				// display block error
				$("#aa_collision").css("display","block");
				// prepend langauge file with data from call
				$("#aa_collision .pad10").prepend(data);
				
			}
								
		},
	});
	// turn collision detection off
	window.onunload = function () {
		$.ajax({  
			url: "ajax.ticket_collision_off.php",
			data: {p_tid: tid, p_uid: uid},
			type: 'POST',  
			async:false //async false fixed safari issue
		});
	}
		
		
});
</script>
<?php

// arrange ticket layout - bottom to top or top to bottom
$update_dir = aa_mysqli_escape(get_settings("Ticket_Dir"));
$update_form_pos = get_settings("Ticket_Reply_Position");
$db_ticket_time = get_settings("Ticket_Time");

// placement of ticket updates and initial enquiry
if ($update_dir == "DESC") {
echo '<script>
	$(document).ready(function() {
	$( "#message_one" ).insertAfter( $( "#message_updates" ) );
	});
	</script>';

}

// placement of update form
if ($update_form_pos == "TOP") {
echo '<script>
	$(document).ready(function() {
	$( "#form_background" ).insertAfter( $( "#table_header" ) );
	});
	</script>';

}

$tid = aa_mysqli_escape($_GET["tid"]);
// set date format from settings
$date_format = get_settings('Date_Format');

// get timezone time to use for inserting and updating records
$now = aa_mysqli_escape(timezone_time());

// select ticket where ID equals tid variable
$sel_ticket = mysqli_query($db, "SELECT t.*,c.*,p.*,u.*, DATE_FORMAT(t.Date_Added, '$date_format') AS DateAdd, 
								DATE_FORMAT(t.Date_Replied, '$date_format') AS DateRep, 
								DATE_FORMAT(t.Date_Updated, '$date_format') AS DateUp, 
								(CASE WHEN t.Date_Closed IS NULL THEN 'N/A' ELSE DATE_FORMAT(t.Date_Closed, '$date_format') END) AS DateClosed,
								(CASE WHEN t.Date_Replied IS NULL THEN 'N/A' ELSE DATE_FORMAT(t.Date_Replied, '$date_format') END) AS DateReplied,					
								(CASE WHEN t.Owner IS NULL THEN 'Unassigned' ELSE CONCAT(u.Fname, ' ' ,u.Lname) END) AS Owned								
								FROM $mysql_ticket AS t 
								LEFT JOIN $mysql_categories AS c ON t.Cat_ID=c.Cat_ID 
								LEFT JOIN $mysql_priorities AS p ON t.Level_ID=p.Level_ID
								LEFT JOIn $mysql_users AS u ON u.UID=t.Owner
								WHERE t.ID = '$tid'");
$ticket = mysqli_fetch_array($sel_ticket);

// select ticket users skills
$user_in_group = mysqli_query($db, "SELECT * FROM $mysql_users_skill AS us WHERE UID = '$loguid' AND CID = '".$ticket["Cat_ID"]."'");
$allowed_to_edit = mysqli_num_rows($user_in_group);

// select groups for count
$sel_cats = mysqli_query($db, "SELECT Cat_ID, Category FROM $mysql_categories WHERE Parent_ID IS NULL ORDER BY Category ASC");
$no_of_cats = mysqli_num_rows($sel_cats);

// select owners for count
$sel_owners = mysqli_query($db, "SELECT * FROM $mysql_users");
$no_of_owners = mysqli_num_rows($sel_owners);

// select priorities for count
$sel_level = mysqli_query($db, "SELECT Level_ID, Level FROM $mysql_priorities");
$no_of_levels = mysqli_num_rows($sel_level);

// update statement for output and count
$tu_state = "SELECT *,DATE_FORMAT(ups.Updated_At, '$date_format') AS Up_At FROM $mysql_ticket_updates AS ups LEFT JOIN $mysql_users AS tu ON tu.UID = ups.Update_By WHERE ups.Ticket_ID = '$tid' ORDER BY ups.Updated_At $update_dir";
// mysql statement to select ticket updates where the parent ID equals the ticket ID
$sel_ticket_updates = mysqli_query($db, $tu_state);

$totalupdates = countsqlrows($tu_state);

// hide delete and edit buttons from agent role
if ($loggedin_user["Role"] == "Agent") {
	$restrict_agent = "restrict_agent";
}
// FILE HANDLING AND DELETING
// create path to delete folder and files with ending slash
$file_path = get_settings("File_Path");
$file_folder = ltrim($tid, '0');
$files_to_delete = $file_path.$file_folder;


// if sql column is populated with files
if ($ticket["Files"] != "") {
	$files = rtrim($ticket["Files"], ",");
	$file_array = explode(",",$files);
	$file_count = count($file_array);
} else {
	$file_count = 0;
}

// delete files from updates ref ajax.ticket_details.php
if (isset($_GET["subdel"])) {
   
	$tu_file_to_del = $_GET["subdel"];
	$tid = aa_mysqli_escape(ltrim($_GET["tid"],"0"));
	$pid = aa_mysqli_escape($_GET["pid"]);
	
	// file path made up of setting, tid and filename
	$file_path_to_del = $file_path.$tid."/".$_GET["subdel"];
	
	// get array from get variable and trim last comma
	$old_tu_file_array = explode(",", rtrim($_GET["tufilearray"],","));

	// remove subfile from array
	$new_tu_file_array = array_diff($old_tu_file_array, array($tu_file_to_del));
	
	// rejoin array to update ticket update table
	$new_tu_file_str = implode(",", $new_tu_file_array);

	// delete file
	unlink($file_path_to_del);

	// update orginal ticket with new file names
	mysqli_query($db, "UPDATE $mysql_ticket_updates SET Update_Files = '$new_tu_file_str' WHERE ID = '$pid'");
	
	// insert update of change into database with now and text from above statements
	mysqli_query($db, "INSERT INTO $mysql_ticket_updates (Ticket_ID, Update_By, Updated_At, Update_Type, Update_Time, Notes, Update_Emailed) 
					VALUES ('$tid', '$loguid', '$now', 'Change', '1', '$tu_file_to_del deleted by $loggedin_user[Fname] $loggedin_user[Lname]', 0)");		
	
	mysqli_close($db);

	header('Location: page.php?page=page.ticket&tid='.$tid.'&pid='.$pid);

}
	
// delete files from master update
if (isset($_GET["del"])) {
	$file_to_del = $_GET["del"];
	$tid = aa_mysqli_escape(ltrim($_GET["tid"],"0"));
	
	// file path made up of setting, tid and filename
	$file_path_to_del = $file_path.$tid."/".$_GET["del"];
	
	$old_file_array = $file_array;
	// remove values from array that are different to the existing
	$new_file_array = array_diff($old_file_array, array($file_to_del));

	// new string for ticket files
	$new_file_str = implode(",", $new_file_array);
	
	// delete file
	unlink($file_path_to_del);

	// update orginal ticket with new file names
	mysqli_query($db, "UPDATE $mysql_ticket SET Files = '$new_file_str' WHERE ID = '$tid'");
	
	// insert update of change into database with now and text from above statements
	mysqli_query($db, "INSERT INTO $mysql_ticket_updates (Ticket_ID, Update_By, Updated_At, Update_Type, Update_Time, Notes, Update_Emailed)
					VALUES ('$tid', '$loguid', '$now', 'Change', '1', '$file_to_del deleted by $loggedin_user[Fname] $loggedin_user[Lname]', 0)");		
	
	mysqli_close($db);

	header('Location: page.php?page=page.ticket&tid='.$tid);
	
}

// update status, category and priority
if (isset($_POST["save"])) {
	
	$new_status = aa_mysqli_escape($_POST["chg_status"]);
	$new_cat = aa_mysqli_escape($_POST["chg_cat"]);
	$new_owner = aa_mysqli_escape($_POST["chg_owner"]);
	$new_priority = aa_mysqli_escape($_POST["chg_priority"]);
	// set change variable
	$change = FALSE;	
	
	// if new status seleected doesn't equal existing status in database	
	if ($new_status != $ticket["Status"]) {
		
		// text to be inserted into ticket update for change of status
		$sql_update .= $lang['ticket-status-chg-status']." ".$ticket["Status"]." ".$lang['ticket-status-chg-to']." ".$new_status."\n";
		// set change variable to true
		$change = TRUE;	
		
	}
	
	// if no categories are configured in settings do not run category update
	if ($no_of_cats > 0) {
	
		// if new category selected doesn't equal existing category in database
		if ($new_cat != $ticket["Cat_ID"]) {
			
			// select old category name from original ticket ID
			$oldcat = mysqli_query($db, "SELECT Cat_ID, Category FROM $mysql_categories WHERE Cat_ID = '".$ticket['Cat_ID']."'");
			$o_cat = mysqli_fetch_array($oldcat);
			
			// select new category name from ID used in select
			$newcat = mysqli_query($db, "SELECT Cat_ID, Category FROM $mysql_categories WHERE Cat_ID = '$new_cat'");
			$n_cat = mysqli_fetch_array($newcat);
			
			// text to be inserted into ticket update for change of category
			$sql_update .= $lang['ticket-status-chg-group']." ".$o_cat["Category"]." ".$lang['ticket-status-chg-to']." ".$n_cat["Category"]."\n";
			
			// set change variable to true
			$change = TRUE;
	
		}
		
	}
	
	// if new status seleected doesn't equal existing status in database	
	if ($new_owner != $ticket["Owner"]) {
	
		// select old owner name from original ticket ID
		$oldowner = mysqli_query($db, "SELECT UID, Fname, Lname FROM $mysql_users WHERE UID = '".$ticket['Owner']."'");
		$o_owner = mysqli_fetch_array($oldowner);
		
		// select new owner name from ID used in select
		$newowner = mysqli_query($db, "SELECT UID, Fname, Lname FROM $mysql_users WHERE UID = '$new_owner'");
		$n_owner = mysqli_fetch_array($newowner);

		// text to be inserted into ticket update for change of status
		$sql_update .= $lang['ticket-status-chg-owner']." ".$o_owner["Fname"]." ".$o_owner["Lname"]." ".$lang['ticket-status-chg-to']." ".$n_owner["Fname"]." ".$n_owner["Lname"]."\n";
		// set change variable to true
		$change = TRUE;	
		
	}	
	
	// if no priorites are configured in settings do not run category update
	if ($no_of_levels > 0) {
	
		// if new priority selected doesn't equal existing priority in database
		if ($new_priority != $ticket["Level_ID"]) {
		
			// select old priority name from original ticket ID
			$oldlevel = mysqli_query($db, "SELECT Level_ID, Level FROM $mysql_priorities WHERE Level_ID = '".$ticket['Level_ID']."'");
			$o_level = mysqli_fetch_array($oldlevel);
			
			// select new priority name from ID used in select
			$newlevel = mysqli_query($db, "SELECT Level_ID, Level FROM $mysql_priorities WHERE Level_ID = '$new_priority'");
			$n_level = mysqli_fetch_array($newlevel);

			// text to be inserted into ticket update for change of priority
			$sql_update .= $lang['ticket-status-chg-priority']." ".$o_level["Level"]." ".$lang['ticket-status-chg-to']." ".$n_level["Level"]."\n";
			
			// set change variable to true
			$change = TRUE;
	
		}

	}
	
	// update original ticket with new status, category or priority and insert update
	if ($change == TRUE) {
				
		// update orginal ticket with new status, category or priority
		mysqli_query($db, "UPDATE $mysql_ticket SET Status = '$new_status', Cat_ID = '$new_cat', Owner = '$new_owner', Level_ID = '$new_priority' WHERE ID = '$tid'");
		
		if ($new_status == "Closed") {
		
			// set closed date for ticket	
			mysqli_query($db, "UPDATE $mysql_ticket SET Date_Closed = '$now' WHERE ID = '$tid'");
		
		}
					// insert update of change into database with now and text from above statements
		mysqli_query($db, "INSERT INTO $mysql_ticket_updates (Ticket_ID, Update_By, Updated_At, Update_Type, Update_Time, Notes, Update_Emailed) 
		VALUES ('$tid', '$loguid', '$now', 'Change', '1', '$sql_update', 1)");
					
		mysqli_close($db);

		// send email of change
		send_email_update($ticket["ID"], $new_status, $ticket["User_Email"], $sql_update);

		// refresh ticket page
		header('Location:'.$_SERVER['REQUEST_URI']);
			
	}
	
}

// submit reply

if (isset($_POST["Form_Reply"])) {
	
	$tid = aa_mysqli_escape($_GET["tid"]);
	$forward_to = form_field_clean($_POST["aa_forward_to"], TRUE);
	$forward_history = $_POST["aa_forward_history"];
	$reply = form_field_clean($_POST["reply"], FALSE);
	$timespent = form_field_clean($_POST["aa_time_spent"], TRUE);
	$status = aa_mysqli_escape($_POST["action_reply"]);

	// apply no formatting to email message for plain text to be held
	$email_format_reply = $_POST["reply"];
	
	$timespent_hhmm = explode(":", $timespent);
	
	
	// if status is closed then set type
	if (isset($_POST["aa_private"])) {
		$public = 0;
		$type = "Note";
		$status = "Pending"; // force due to dropdown being disabled
	} else {
		
		if ($status == "Closed") {
			$type = aa_mysqli_escape("Close");
		} else {
			$type = aa_mysqli_escape("Update");
		}
		$public = 1;
		
	}
	

	
	$form_error = array();
	
		// if forward address entered check valid address
		if (!empty($forward_to)) {
			if (form_validate ("EMAIL", $forward_to) === TRUE) {
				$form_error['FORWARD'] = $lang['generic-error-invalid-em'];
			}
		}
		
		// check name
		if (form_validate ("TEXT", $reply) === TRUE) {
				
			$form_error['REPLY'] = $lang["generic-error"];
				
		}
		
		// format time spent
		if (!is_numeric($timespent_hhmm[0])) { // check hour is numeric
			
			$form_error['TIMESPENT'] = $lang['generic-error-inv-format'];
		
		} else if (!is_numeric($timespent_hhmm[1])) { // check minutes is numeric
			
			$form_error['TIMESPENT'] = $lang['generic-error-inv-format'];

		} else if (strlen($timespent_hhmm[1]) > 2) { // no minutes over two digits
			
			$form_error['TIMESPENT'] = $lang['generic-error-inv-format'];

		} else if ($timespent_hhmm[1] > 59) { // no minutes over 59
			
			$form_error['TIMESPENT'] = $lang['generic-error-inv-format'];
		
		} else { // calculate time to entered
		
			$timetotal = ($timespent_hhmm[0]*60) + ($timespent_hhmm[1]);
			
		}
		
		$files = $_FILES["file"];
		$no_of_files = count($_FILES["file"]["name"]);	
		
		for ($f = 0; $f < $no_of_files; $f++) {
			if (!empty($_FILES["file"]["name"][$f])) {	
			
				if(aa_validate_files($_FILES["file"]["name"][$f], $_FILES["file"]["size"][$f]) === false) {
					$form_error['FILE'] = $lang['generic-file-size-exc'].
										"<br />".$lang['generic-file-size-rule']." ".(get_settings("File_Size") / 1048576)."MB".
										"<br />".$lang['generic-file-type-rule']." ".get_settings("File_Type");
					break;
				} else {
					@$aa_files .= $_FILES["file"]["name"][$f].",";
				}
				
			}
		}
		
		// if no errors
		if (empty($form_error)) {
			// set date format from settings
			$now = aa_mysqli_escape(timezone_time());
			$assignment = ($ticket_assignment == NULL) ? aa_mysqli_escape("NULL") : aa_mysqli_escape($ticket_assignment);
			
			mysqli_query($db, "INSERT INTO $mysql_ticket_updates (Ticket_ID, Update_By, Updated_At, Update_Type, Update_Time, Forward_To, Notes, Update_Files, Update_Emailed) 
			VALUES ('$tid', '$loguid', '$now', '$type', '$timetotal', '$forward_to', '$reply', '$aa_files', $public)") or die(mysql_error());  

			// get date replied field to check if NULL for initial insert
			$sel_datereplied = mysqli_query($db, "SELECT Date_Replied FROM $mysql_ticket WHERE ID = '$tid'");	
			$datereplied = mysqli_fetch_array($sel_datereplied);
			
			// if the update is an update or a close and date replied is null then add time.
			if ($datereplied["Date_Replied"] == NULL && ($type == "Update" || $type == "Close")) {
				$replydate = "Date_Replied = '".$now."',";
			} else {
				$replydate = "";
			}
				
			if ($status == "Closed") {
			
				// set closed date for ticket	
				mysqli_query($db, "UPDATE $mysql_ticket SET $replydate Status = '$status', Date_Updated = '$now', Date_Closed = '$now' WHERE ID = '$tid'");
			
			} else {
				
				// set update ticket
				mysqli_query($db, "UPDATE $mysql_ticket SET $replydate Status = '$status', Date_Updated = '$now' WHERE ID = '$tid'");
			
			}
				
			// if file has been uploaded upload each file
			if (!empty($files["name"][0])) {

				// loop through each attachement and upload
				for ($key = 0; $key <= $no_of_files; $key++) {
				
					if (!is_dir($file_path.$file_folder)) {
    					@mkdir($file_path.$file_folder);
					}
					
					// move each uploaded file to folder
					move_uploaded_file($files["tmp_name"][$key], $file_path.$file_folder."/".$files["name"][$key]);	
				
				}
				
			}
			
			// if forward address entered the forward message
			if (isset($forward_to)) {
				send_email_update($ticket['ID'], "Forward", $forward_to, $email_format_reply.$forward_history);
			}
			
			// if make update public and email is ticked
			if ($public == 1) {

				// send email using custom function
				send_email_update($ticket['ID'], $status, $ticket['User_Email'], $email_format_reply);
			
			} else {
				
				// else send notification of private message
				send_email_notification_private_ticket($ticket['ID']);				
			
			}
			
			mysqli_close($db);
			
			header('Location: page.php?page=page.ticket&tid='.$tid);
						
		}	

}

?>
<div id="tid" tid="<?php echo $tid; ?>" uid="<?php echo $loguid; ?>" filefolder="<?php echo $files_to_delete; ?>"></div>

<div id="body-left" class="body-20 border-color clear">
    <div class="pad10">
    <p class="hide-desktop"><a href="#" id="open-filter"><i class="fa fa-file-text-o"></i></a></p>
    <span class="hide-mobile"><p><?php echo $lang['ticket-details-title']; ?></p></span>
    </div>
    <div id="inner-body-left">
    <div class="pad10">
        <div class="hide-desktop" id="filter-close"><p><i class="fa fa-arrow-circle-o-right"></i></p></div>    

        <form action="" method="post">
        <strong><?php echo $lang['tickets-ID']; ?></strong>
        <p><?php echo $ticket["ID"]; ?></p>
        <p><strong><?php echo $lang['search-cust']; ?></strong></p>
		<p><?php echo ucwords(html_entity_decode(stripslashes($ticket["User"]))); ?></p>        
        <?php
        $ticket_reopen = get_settings("Ticket_Reopen");
        // if ticket closed and not allowed to reopen or not skilled in group or no owner yet
        if ($ticket["Status"] == "Closed" && ($ticket_reopen == 0) || ($allowed_to_edit == "0") || ($ticket["Owner"] == NULL)) {
        ?>
        <p><strong><?php echo $lang['tickets-status']; ?></strong></p>
		<p><?php echo $ticket["Status"]; ?></p>
        <p><strong><?php echo $lang['tickets-group']; ?></strong></p>
		<p><?php echo decode_entities($ticket["Category"]); ?></p>
        <p><strong><?php echo $lang['tickets-owner']; ?></strong></p>
		<p><?php echo decode_entities($ticket["Owned"]); ?></p>
        <p><strong><?php echo $lang['tickets-priority']; ?></strong></p>
		<p><?php echo decode_entities($ticket["Level"]); ?></p>
        <?php
        } else { 
        ?>   
        <p><strong><?php echo $lang['tickets-status']; ?></strong></p>
        <?php
        // available statues
    	$status_options = array("Open" => $lang['tickets-status-open'], "Pending" => $lang['tickets-status-pending'],
					 "Paused" => $lang['tickets-status-paused'], "Closed" => $lang['tickets-status-closed']);
        ?>
        <p>
        <select id="chg_status" name="chg_status" style="width:100%">
        <?php
        // print each available status within select box
        foreach ($status_options as $opt_val => $opt_key) {
        
            if ($ticket["Status"] == $opt_val) {
            
            echo "<option value=\"".$opt_val."\" selected=\"selected\">".$opt_key."</option>";
            
            } else if ($ticket["Status"] != $opt) {
            
            echo "<option value=\"".$opt_val."\">".$opt_key."</option>";
            
            }
        
        }
        ?>
        </select>
        <p><input class="collision_disable" name="save" type="submit" value="<?php echo $lang['generic-change']; ?>" /></p>
        </p>    
        <?php
        // if no categories are configured in settings do not show change category box
        if ($no_of_cats > 0) {
        ?>
        <p><strong><?php echo $lang['tickets-group']; ?></strong></p>  
        <p><select id="chg_cat" name="chg_cat" style="width:100%">
                <?php
                
                // loop through each available category and print within select box
                while ($cats = mysqli_fetch_array($sel_cats)) {
                    
                    if ($ticket["Cat_ID"] == $cats["Cat_ID"]) {
                        
                        echo "<option value=\"".$cats["Cat_ID"]."\" selected=\"selected\">".decode_entities($cats["Category"])."</option>";
              
                    } else if ($ticket["Cat_ID"] != $cats["Cat_ID"]) {
                        
                        echo "<option value=\"".$cats["Cat_ID"]."\">".decode_entities($cats["Category"])."</option>";
                    
                    }
                                
                }
              
              ?>
        </select>
        <p><input class="collision_disable" name="save" type="submit" value="<?php echo $lang['generic-change']; ?>" /></p>
        </p>
        <?php
        }
        ?>    
        </p>
        <p><strong><?php echo $lang['tickets-owner']; ?></strong></p>
        <p>
        <select id="chg_owner" name="chg_owner" style="width:100%">
            <?php
            
            // loop through each available category and print within select box
            while ($owner = mysqli_fetch_array($sel_owners)) {
                
                if ($owner["UID"] == $ticket["Owner"]) {
                    
                    echo "<option value=\"".$owner["UID"]."\" selected=\"selected\">".$owner["Fname"]." ".$owner["Lname"]."</option>";
          
                } else if ($owner["UID"] != $ticket["Owner"]) {
                    
                    echo "<option value=\"".$owner["UID"]."\">".$owner["Fname"]." ".$owner["Lname"]."</option>";
                
                }
                            
            }
          
          ?>
        </select>
        <p><input class="collision_disable" name="save" type="submit" value="<?php echo $lang['generic-change']; ?>" /></p>
        </p>
        <?php
        // if no levels are configured in settings do not show change priority box
        if ($no_of_levels > 0) {
        ?>
        <p><strong><?php echo $lang['tickets-priority']; ?></strong></p>
        <p><select id="chg_priority" name="chg_priority" style="width:100%">
            <?php
            
            while ($levels = mysqli_fetch_array($sel_level)) {
            
                // select the value of the priority that has been assigned to the ticket
                if ($ticket["Level_ID"] == $levels["Level_ID"]) {
                
                    echo "<option value=\"".$levels["Level_ID"]."\" selected=\"selected\">".decode_entities($levels["Level"])."</option>";
                
                // else print all the other values avaialble for priority
                } else if ($ticket["Level_ID"] != $levels["Level_ID"]) {
                
                    echo "<option value=\"".$levels["Level_ID"]."\">".decode_entities($levels["Level"])."</option>";
                    
                }
            
            }
            ?>
        </select>
        <p><input class="collision_disable" name="save" type="submit" value="<?php echo $lang['generic-change']; ?>" /></p>
        </p>     
        <?php
		// end if no of levels is 0
		}
		// end editable priority, owner, group
		}
		?>
        <p><strong><?php echo $lang['tickets-dateadd']; ?></strong></p>
		<p><?php echo $forward_dateadd = $ticket["DateAdd"]; ?></p>
        <p><strong><?php echo $lang['ticket-dateintrep']; ?></strong></p>
		<p><?php echo $ticket["DateReplied"]; ?></p>
        <p><strong><?php echo $lang['tickets-dateup']; ?></strong></p>
		<p><?php echo $ticket["DateUp"]; ?></p>
        <p><strong><?php echo $lang['ticket-dateclosed']; ?></strong></p>
		<p><?php echo $ticket["DateClosed"]; ?></p>
        </p>
        </form>
	</div>
    </div>
</div>
<?php
// define if page 60 or 80
$allow_feedback = get_settings("Ticket_Feedback");
if ($ticket["Status"] == "Closed" && $allow_feedback == 1) {
	$body_page_width = 'body-60-w-border';
	$body_right_show = true;
} else {
	$body_page_width = 'body-80';
}
?>
    <div id="body-middle" class="<?php echo $body_page_width; ?> bg-color-body-inner">
        
        <div id="table_header">
            <div id="table_generic">
			<?php
            // if skilled in group and ticket is unassigned
            if ($allowed_to_edit == 1 && ($ticket["Owner"] == NULL)) {
            ?>
            <a href="#" id="accept" title="<?php echo $lang['tickets-status-accept']; ?>"><i class="fa fa-thumbs-up"></i></a>
            <?php
            }
            
            //echo $ticket["Status"]." ".$ticket_reopen." ".$allowed_to_edit." ".$ticket["Owner"];
            if ($ticket["Status"] != "Closed" && ($ticket["Owner"] != NULL  || $ticket["Owner"] == $loguid)) {
            
            echo '<a href="#" id="merge" class="open_popup" title="Merge"><i class="fa fa-compress"></i></a>';
            
			
			
            echo '<a href="#" id="delete" class="'.@$restrict_agent.'" title="'.$lang["generic-delete"].'"><i class="fa fa-trash-o"></i></a>';
            
            }
            ?>
            </div>
            <div id="table_go_back">
  			<?php
			// previous ticket id arrow
			$prevresult = @mysqli_query($db, "SELECT * FROM $mysql_ticket WHERE ID < ".$tid." AND Status != 'Closed' LIMIT 1");
			if(@mysqli_num_rows($prevresult) > 0)
			{
				$prevrow = mysqli_fetch_array($prevresult);
				$previd  = $prevrow['ID'];
                echo '<a href="page.php?page=page.ticket&tid='.$previd.'"><i class="fa fa-chevron-left"></i></a>';
			}
			
			// next ticket id arrow
			$nextresult = @mysqli_query($db, "SELECT * FROM $mysql_ticket WHERE ID > ".$tid." AND Status != 'Closed' LIMIT 1");
			
			if(@mysqli_num_rows($nextresult) > 0)
			{
				$nextrow = mysqli_fetch_array($nextresult);
				$nextid  = $nextrow['ID'];
                echo '<a href="page.php?page=page.ticket&tid='.$nextid.'"><i class="fa fa-chevron-right"></i></a>';
			}
			?>
            </div>
        </div>
    <div class="error-msg" id="aa_collision"><div class="pad10"> <?php echo $lang['ticket-status-collide']; ?></div></div>
    <?php
	
	if ($ticket["Status"] == "Closed") { // if ticket status is set to close then don't show the update form.
		
		echo "<div id=\"aa_ticket_error\" class=\"error-msg\"><div class=\"pad10\">".$lang['ticket-status-closed']."</div></div>";
		$show_form = false;
   
	} else if ($allowed_to_edit == "0") { // if user not skilled in group
		
		echo "<div id=\"aa_ticket_error\" class=\"error-msg\"><div class=\"pad10\">".$lang['ticket-status-notskill']."</div></div>";
		$show_form = true;
		$noteonly = true;

	} else if ($ticket["Owner"] == NULL) { // if unassigned
		
		echo "<div id=\"aa_ticket_error\" class=\"error-msg\"><div class=\"pad10\">".$lang['ticket-status-unassigned']." <i class=\"fa fa-thumbs-up\"></i></div></div>";
		$show_form = false;
	
	} else if ($ticket["Owner"] != $loguid) { // ticket not owned by logged in agent
		
		echo "<div id=\"aa_ticket_error\" class=\"error-msg\"><div class=\"pad10\">".$lang['ticket-status-notowner'] ."</div></div>";
		$show_form = true;
		$noteonly = true;
		
	} else { // ticket is owned by logged in agent
		
		$show_form = true;
		$noteonly = false;

	}	
	?>
    
        
    <div class="user-msg" id="message_one">
        <div class="pad10">
			
            <span class="<?php echo @$restrict_agent; ?> click_editable"><a href="#"><i class="fa fa-pencil"></i></a></span>
            <br />
            <span class="editable pagetitle" contenteditable="false" type="ts" tid="<?php echo $ticket["ID"]; ?>"><?php echo $forward_subject = decode_entities($ticket["Subject"]); ?></span>
			
            <br />
            <span style="float:left;"><b><?php echo $forward_user = ucwords(html_entity_decode(stripslashes($ticket["User"]))); ?></b></span>
            <span style="float:right"><?php echo $ticket["DateAdd"]; ?></span>
            <br />
            <span class="<?php echo @$restrict_agent; ?> click_editable"><a href="#"><i class="fa fa-pencil"></i></a></span>
			<br />
            <?php
			$preg_search = array('/&nbsp;/');
			// converted html entities
			$ticket['Message'] = decode_entities($ticket['Message']);

			// if widget message use nl2br otherwise convert html
			echo "<span class=\"editable\" contenteditable=\"false\" type=\"tb\" tid=\"".$ticket["ID"]."\">".$message = $ticket['Type'] == 'Widget' ? nl2br($ticket['Message']) : preg_replace($preg_search, " ", $ticket['Message'])."</span>";
            
			?>
            <?php
            $sel_custom_fields = @mysqli_query($db, "SELECT Field_Name FROM $mysql_custom_fields") or die(mysql_error());
            $count_custom_fields = mysqli_num_rows($sel_custom_fields);
            
            if ($count_custom_fields > 0 && ($ticket['Type'] == 'Web')) {
            
            ?>
            <br />
            <fieldset>
            <legend><?php echo $lang['ticket-customfields']; ?></legend>
            <?php      
            while ($custom_field = mysqli_fetch_array($sel_custom_fields)) {
                
				// split values by #  
                $custom_value = str_replace("#", "<br>", $ticket[$custom_field["Field_Name"]]);
    
                if ($custom_value == "") {
                
                    $custom_value = "N/A";
                
                }
                    
                echo "<p><b>".str_replace('_', ' ', $custom_field["Field_Name"])."</b></p><p>".nl2br($custom_value)."</p>";
                
            }      
            ?>    
            </fieldset>
            <br />
            <?php
            // end count of custom fields
            }
            ?>
            
            <?php 
            if ($file_count) {
            ?>
            <br />
            <fieldset>
            <legend><?php echo $lang['ticket-fileuploads']; ?></legend>
            <?php
            foreach ($file_array as $file) {
            
                echo "<p><a href=\"".$file_path.$file_folder."/".$file."\" download=".$file.">".$file."</a> 
                <a href='page.php?page=page.ticket&tid=".$ticket["ID"]."&del=".$file."'><i class=\"fa fa-trash-o\"></i></a></p>";
            
            }
            ?>
            </fieldset>
            <br />
            <?php	
            }
            ?>
        
        </div>
    </div>
    
	<div id="message_updates">
	<?php
    
    $indent_val = 10;
	$i = 1;

    // loop through each ticket update
    while ($ticket_update = @mysqli_fetch_array($sel_ticket_updates)) {
		
	?>
    <a name="<?php echo $ticket_update["ID"]; ?>"></a>
    <?php
            
    // if sql column is populated with files
    if ($ticket_update["Update_Files"] != "") {
        $tu_files = rtrim($ticket_update["Update_Files"], ",");
        $tu_file_array = explode(",",$tu_files);
        $tu_file_count = count($tu_file_array);
    } else {
        $tu_file_count = 0;
    }
    ?>
    
    <?php
    if ($ticket_update["Update_Type"] == "Change") {
    ?>
            
    <div class="change-msg" id="<?php echo $ticket_update["ID"]; ?>">
        <div class="pad10">&nbsp;     
            <span style="float:left"><?php echo decode_entities(stripslashes($ticket_update["Notes"]))." by <b>".$ticket_update["Fname"]." ".$ticket_update["Lname"]."</b>";  ?></span>
        	<span style="float:right"><?php echo $ticket_update["Up_At"]; ?></span>
        </div>
    </div>
        
    <?php	
    
    } else {
    
    // css color profile for private messages
	if ($ticket_update["Update_Emailed"] == 0) {
        
        $staff_block = "staff-msg-private";
        $file_highlight_color = "light_yellow";
    
    } else {
        
		// if numeric then staff message otherwise user message
		if (is_numeric($ticket_update["Update_By"])) {
			$staff_block = "staff-msg";
			$file_highlight_color = "light_blue";		
		} else {
			$staff_block = "user-msg";
		}
		
    }
    
    // if update not by admin print user name
    if ($ticket_update["Fname"] == NULL) {
        $name = $ticket_update["Update_By"];
    } else {
        $name = $ticket_update["Fname"]." ".$ticket_update["Lname"];
    }
	
	// for forward history
	$new_indent_val = $indent_val*$i;
	// content of forward message
	$indent = str_replace("<p>", "<p style=\"text-indent:".$new_indent_val."px\">", decode_entities($ticket_update["Notes"]));
	$forward_to_body .= "<p style=\"text-indent:".$new_indent_val."px\">".$name."<p style=\"text-indent:".$new_indent_val."px\">".$ticket_update["Up_At"]."</p><p>".$indent."</p><hr>";	
    
	$i++;
	
	?>
    
    	<div class="<?php echo $staff_block; ?>" id="<?php echo $ticket_update["ID"]; ?>">
       		<div class="pad10">
            <span style="float:left"><b><?php echo $name; ?></b></span>
            <span style="float:right"><?php echo $ticket_update["Up_At"]; ?></span>            
            <?php
           	$ticket_update["Notes"] = decode_entities($ticket_update["Notes"]);  
			
			// show duration for each update
			$hours = intval($ticket_update["Update_Time"] / 60);
			$mins = sprintf("%02s", $ticket_update["Update_Time"] % 60);

			echo ($db_ticket_time == 1) ? '<br>'.$lang['ticket-duration'].': '.$hours.':'.$mins : '';
			
			// if not empty show forward to address
			if (!empty($ticket_update["Forward_To"])) {
			echo "<br>".$lang['ticket-forwarded-to']." ". $ticket_update["Forward_To"];
			}
			
			?>
            <br />
            <span class="<?php echo @$restrict_agent; ?> click_editable"><a href="#"><i class="fa fa-pencil"></i></a></span>
            <a class="<?php echo @$restrict_agent; ?> click_delete" tid="<?php echo $ticket_update["ID"]; ?>" echo  href="#"><i class="fa fa-times"></i></a>
			
            <?php
			echo "<br><span class=\"editable\" contenteditable=\"false\" type=\"tu\" tid=\"".$ticket_update["ID"]."\">".$ticket_update["Notes"] = preg_replace($preg_search, " ", $ticket_update["Notes"])."</span>";
            ?>
            
            <?php 
            if ($tu_file_count) {
            ?>
            <br />
            <fieldset>
            <legend><?php echo $lang['ticket-fileuploads']; ?></legend>
            <?php			
            foreach ($tu_file_array as $tu_file) {
                                    
                    echo "<p><a href=\"".$file_path.$file_folder."/".$tu_file."\" download=".$tu_file.">".$tu_file."</a> </i>
                    <a href='page.php?page=page.ticket&tid=".$ticket["ID"]."&pid=".$ticket_update["ID"]."&subdel=".$tu_file."&tufilearray=".$ticket_update["Update_Files"]."'>
                    <i class=\"fa fa-trash-o\"></i></a></p>";
                    
                }
            ?>
            </fieldset>
            <br />
            <?php	
            }
            ?>
            </div>
        </div>
		<?php
            }
        
        }
        ?>
        </div> <!--- end div message_updates -->
		<?php
    

        
        if ($show_form) {
		// combine ticket request and all updates to make forward history
		$forward_history = "<hr>".$forward_subject."<br>".$forward_user."<br>".$forward_dateadd."<br>".$ticket['Message']."<hr>".$forward_to_body;
        ?>
        <div id="form_background">
            <div class="pad10">
            <a name="form"></a>
            <form id="form_add_update" name="form_add_update" method="post" action="<?php echo $_SERVER['REQUEST_URI']."#form"; ?>" enctype="multipart/form-data">            
                
				<?php
				if ($noteonly != true) {
				?>	            
                    <div>
                    <a id="aa_forward_toggle" href="#"><?php echo $lang['ticket-forward']; ?> <i class="fa fa-share"></i></a>
                    <input type="text" id="aa_forward_to" name="aa_forward_to" placeholder="<?php echo $lang['ticket-forward-to']; ?>" value="<?php echo @$forward_to; ?>" />
					<?php  echo "<p class=\"error\">".$form_error['FORWARD']."</p>"; ?>
                    
                    <textarea name="aa_forward_history" style="display:none; visibility:hidden"><?php echo $forward_history; ?></textarea>
                    </div>
                <?php
				}
				?>
                
                <div>
                <select id="can_reply" name="can_reply">
                <option></option>
                <?php
                // select canned replies from database
                $sel_can_msg = mysqli_query($db, "SELECT * FROM $mysql_canned_msg") or die(mysql_error());
                while ($can = mysqli_fetch_array($sel_can_msg)) {
                
                echo "<option value=\"".$can["Can_Message"]."\">".$can["Can_Title"]."</option>";
                }
                ?>
                </select>  
                </div>

				<?php  echo "<div style=\"clear:both\"><p class=\"error\">".$form_error["REPLY"]."</p></div>"; ?>
                <textarea id="reply" name="reply" placeholder="Write update"><?php echo @$email_format_reply.nl2br($loggedin_user["Signature"]); ?></textarea>                
                <div>
				<?php
                $file_attachment = get_settings("File_Enabled");
                if ($file_attachment == 1) {
                ?>
                <div id="fileuploads">
		        <input type="hidden" id="aafilelimit" value="<?php echo get_settings("File_Limit"); ?>" />        
                <p><input class="aafile" name="file[]" type="file"/></p>
                <?php echo "<p><span class=\"error\">".$form_error["FILE"]."</span></p>"; ?>            
                </div>
                <p><a href="#" id="addfile"><?php echo $lang['ticket-attachanother']; ?></a></p>
                <?php
                }
                ?>
                <p>
                </div>

                <div>
                <?php
				if ($db_ticket_time == 1) {
				
					echo '<input type="text" id="aa_time_spent" name="aa_time_spent" style="width:10%" value="0:01"/>';
					echo '<label>'.$lang['ticket-time-spent'].'</label>';
					echo "<span class=\"error\">".$form_error['TIMESPENT']."</span>";
				
				} else {
					echo '<input type="hidden" id="aa_time_spent" name="aa_time_spent" style="width:10%" value="0:01"/>';
                }
				?>
                </div>
                
                <div>
                <?php
                if ($noteonly == true) {
					echo '<input name="aa_private_disabled" id="aa_private_disabled" type="checkbox" value="1" checked="checked" disabled="disabled"/>'; // visible
					echo '<input name="aa_private" id="aa_private" type="checkbox" value="1" checked="checked" style="display:none;"/>'; // used for value in php
				} else {
					echo '<input name="aa_private" id="aa_private" type="checkbox" value="0"/>';
				}
				?>
        		<label for="aa_private"><?php echo $lang['ticket-status-dd-note']; ?></label>
				</div>
                
                <?php
				if ($noteonly != true) {
				?>	            
                    <div>
                    <select id="action_reply" name="action_reply">
                    <option value="Pending" selected="selected"><?php echo $lang['ticket-status-dd-update']; ?></option>
                    <option value="Paused"><?php echo $lang['ticket-status-dd-pause']; ?></option>
                    <option value="Closed"><?php echo $lang['ticket-status-dd-close']; ?></option>
                    </select>
                    </div>
                <?php
				}
				?>
                <div>
                <p><input type="submit" id="Form_Reply" name="Form_Reply" value="<?php echo $lang['generic-save']; ?>" /></p>
                </div>
                
            </form>   
            
            <p>&nbsp;</p>
            
            </div>
        </div>
        <?php
        // end if not closed.name="reply" name="action_reply" id="email_reply"
        }
        
        ?>
        </div>
	<?php
    if ($body_right_show) {
    ?>
    <div id="body-right" class="body-20 ticket-rating">
        <div class="pad10">
            <p style="font-size:medium;"><?php echo $lang['ticket-rating']; ?></p>
            <?php
            if ($ticket["Feedback"] == NULL) {
            ?>
            <p><?php echo $lang['ticket-rating-waiting']; ?></p>
            <?php
            }
            ?>
            <ul>
            <?php
            // array for rating. number is sql value
			$ratings = array("2" => $lang['ticket-rate-p'], "1" => $lang['ticket-rate-neu'], "0" => $lang['ticket-rate-neg']);
            foreach ($ratings as $rating_key => $rating_value) {
				
				switch ($rating_key) {
					case "2":
						$aa_rating_style = "Positive";
						break;
					case "1":
						$aa_rating_style = "Neutrel";
						break;
					case "0":
						$aa_rating_style = "Negative";
						break;
				}
				
                // if no rating submited
                if ($ticket["Feedback"] == NULL) {
        
                    echo "<li id=\"".$aa_rating_style."\" rval=\"".$rating_key."\">".ucwords($rating_value)."</li>";			
        
                // if feedback given and matches db
                } else if ($ticket["Feedback"] == $rating_key) {
            
                    echo "<li id=\"".$aa_rating_style."\" class=\"selected\" rval=\"".$rating_key."\">".ucwords($rating_value)."<i class=\"fa fa-check\"></i></li>";
            
                // else must be unselected options
                } else {
                    
                    echo "<li id=\"".$aa_rating_style."\" class=\"disabled-li\" rval=\"".$rating_key."\">".ucwords($rating_value)."</li>";			
                    
                }
            
            }
            
            ?>
            </ul>
        </div>
    </div>
    <?php
	}
	?>
    
    
    <div class="popup">
    <div class="popup_header"><?php echo $lang['ticket-merge']; ?> <a href="#" class="close_popup">x</a></div>
    <div class="popup_content">
		<div class="popup_ticket">
        <div class="ticket_summary">
        <?php echo "<p><strong>".$ticket["Subject"]."</strong></p><p>".$ticket["User"]."</p>"; ?>
        </div>
        <div class="ticket_numbers"><p class="detail"><i class="fa fa-calendar"></i> <?php echo $lang['search-added']; ?> <?php echo $ticket["DateAdd"]."</p><p class=\"detail\">(#".$ticket["ID"]; ?>)</p>
        </div>
    	</div>
        <form method="post">
        <p><b><?php echo $lang['ticket-merge-detail']; ?></b></p>
        <input autocomplete="off" id="merge_input" name="search" type="text" placeholder="Search by ID"> <input style="font-size:0px; line-height:0px; height:0px; border:none; width:0px; margin:0px; background:none;" id="merge_search" name="merge_search" type="submit" value="Search">
        </form>
        
        <div id="merge_results"></div>
    
    </div>
</div>
