<?php

include 'settings.php';

// load admin content page
function load_page ($pagename) {
	
	// include langauge files into included pages function
	global $lang, $loguid, $loggedin_user, $db,$mysql_ticket, $mysql_ticket_updates, $mysql_categories,
	$mysql_priorities,$mysql_custom_fields, $mysql_settings, $mysql_canned_msg, $mysql_users, $mysql_users_skill,
	$mysql_kb, $mysql_kb_groups, $mysql_imail; 
	
	$page = $pagename.".php";
	
	if (file_exists($page)) {
		
		validate_logon();	
		include $pagename.".php";
	
	} else {
		
		include '404.php';
	
	}
	
}


function user_load_page($pagename) {
	global $lang, 
	$db,
	$mysql_ticket,
	$mysql_ticket_updates,
	$mysql_categories,
	$mysql_priorities,
	$mysql_custom_fields,
	$mysql_settings,
	$mysql_canned_msg,
	$mysql_users,
	$mysql_users_skill,
	$mysql_kb,
	$mysql_kb_groups,
	$mysql_imail;
	$page = $pagename.".php";
	if (file_exists($page)) {
	
		include $pagename.".php";
	
	} else {
	
		echo 'No file';
	
	}
	
}


// select langauge file and generate select box	
function select_langauge() {
		
	$dir    = '../langauge';
	$directory = scandir($dir);
	$scanned_directory = array_diff($directory, array('..', '.','.DS_Store'));
	
	$default_lang = get_settings("Langauge");
			
	echo '<select name="lang" id="lang">';
	
	foreach ($scanned_directory as $lang_file) {
	
	$lang_file = str_replace('.php', '', $lang_file);
	
	if ($default_lang == $lang_file) {
		echo '<option value='.$lang_file.' selected="selected">'.ucfirst($lang_file).'</option>';
	} else if (@$_SESSION['aa-user-lang'] == $lang_file) {
		echo '<option value='.$lang_file.' selected="selected">'.ucfirst($lang_file).'</option>';
	} else {
		echo '<option value='.$lang_file.'>'.ucfirst($lang_file).'</option>';
	}
	
	}
	
	echo '</select>';
        
}


// select the db value of the status and use the selected lang
function aa_select_ticket_status_lang($ticket_status) {
	
	global $lang;
	
	switch ($ticket_status) {
		case "Open":
			$aa_ticket_status_lang = $lang['tickets-status-open'];
			break;
		case "Pending":
			$aa_ticket_status_lang = $lang['tickets-status-pending'];
			break;
		case "Paused":
			$aa_ticket_status_lang = $lang['tickets-status-paused'];
			break;
		case "Closed":
			$aa_ticket_status_lang = $lang['tickets-status-closed'];
			break;	
	}
	return $aa_ticket_status_lang;
}


// select the db value of the type and use the selected lang
function aa_select_ticket_type_lang($ticket_type) {
	
	global $lang;
	
	switch ($ticket_type) {
		case 'Web':
			$aa_ticket_type_lang = '<i class="fa fa-globe"></i> '.$lang['ticket-type-form'];
			break;
		case 'Chat':
			$aa_ticket_type_lang = '<i class="fa fa-comments"></i> '.$lang['ticket-type-chat'];
			break;
		case 'Widget':
			$aa_ticket_type_lang = '<i class="fa fa-globe"></i> '.$lang['ticket-type-widget'];
			break;
		case 'Email':
			$aa_ticket_type_lang = '<i class="fa fa-envelope-o"></i> '.$lang['ticket-type-email'];
			break;
	}
	return $aa_ticket_type_lang;	
}


// connect to database
function db_connect() {

	global $mysql_host, $mysql_user, $mysql_pass, $mysql_db;
		
	$db = mysqli_connect($mysql_host, $mysql_user, $mysql_pass, $mysql_db);	

		// Check connection
		if (mysqli_connect_errno($db)) {
			echo 'Failed to connect to MySQL: ' . mysqli_connect_error();
		}
		
	return $db;	
	// set default timezone on any mysql
	date_default_timezone_set(get_settings("Timezone"));
	
}

//
function aa_mysqli_escape($var_escape) {
	
	$aa_conn = db_connect();
	
	return mysqli_real_escape_string($aa_conn, $var_escape);
	
}


// count sql rows
function countsqlrows ($query) {
	
global $db;	
	
	if ($stmt = mysqli_prepare($db, $query)) {

		/* execute query */
		mysqli_stmt_execute($stmt);
	
		/* store result */
		mysqli_stmt_store_result($stmt);
	
		$res = mysqli_stmt_num_rows($stmt);
	
		/* close statement */
		mysqli_stmt_close($stmt);
	
	}
	
	return $res;
	
}

// check if user is logged in
function validate_logon () {
		
	if (!isset($_SESSION["acornaid_user"])) {
		
		header('Location: index.php');
		
	}
	
}


// validate form field for text and numbers
function form_validate ($type, $field) {

	if ($type == 'TEXT') {
	
		if ($field == NULL) {
						
			return TRUE;

		}
		
	}
	
	if ($type == 'EMAIL') {
	
		if (!filter_var($field, FILTER_VALIDATE_EMAIL)) {
		
			return TRUE;
			
		}
		
	}	
	
}

function form_error ($field, $array) {

	if (in_array($field, $array)) {
	
		echo "error";
		
	}

}


// clean inputted data
function form_field_clean ($input, $allow_strip) {

	$link = db_connect();

	$input = trim($input);
	$input = mysqli_real_escape_string($link, $input);

	if ($allow_strip == TRUE) {
	
	$input = strip_tags($input);
	
	}
	
	$input = htmlentities($input);
	
	return $input;

}


// decode entities in mysql
function decode_entities($input) {
	
	$input = html_entity_decode(stripslashes($input));
	
	return $input;
	
}


// count number of tickets for each status
function aa_dashboard_count_totals($status) {

	$db = db_connect();

	global $mysql_ticket;
	
	$status = aa_mysqli_escape($status);
		
	$count_tickets_by_status = mysqli_query($db, "SELECT * FROM $mysql_ticket WHERE Status = '$status'") or die("Fault counting tickets by status");
	
	$ticket_status_total = mysqli_num_rows($count_tickets_by_status );
	
	return $ticket_status_total;
	
}

	
// get settings
function get_settings ($printval) {
	
	$db = db_connect();
	
	global $mysql_settings;
		
	$sel_settings = mysqli_query($db, "SELECT * FROM $mysql_settings") or die("Fault selecting settings table");
	$setting = mysqli_fetch_array($sel_settings);
		
	return @$setting["".$printval.""];
	
}


// set default time zone from settings general page
function timezone_time() {
		
	date_default_timezone_set(get_settings("Timezone"));

	return date("Y-m-d H:i:s");
	
}


// highlight search results
function highlight($needle, $haystack){ 
    $ind = stripos($haystack, $needle); 
    $len = strlen($needle); 
    if($ind !== false){ 
        return substr($haystack, 0, $ind) . "<mark>" . substr($haystack, $ind, $len) . "</mark>" . 
            highlight($needle, substr($haystack, $ind + $len)); 
    } else return $haystack; 
}


// validate uploaded files
function aa_validate_files($filename, $filesize) {

	$aa_file = basename($filename);
	$aa_filetype = pathinfo($filename,PATHINFO_EXTENSION);

	$allowed_file_size = get_settings("File_Size");
	$allowed_file_types = str_replace(" ", "", get_settings("File_Type"));	
	$file_type_whitelist = explode(",", $allowed_file_types);
	
	if ($filesize > $allowed_file_size) {
		return $error = false;
	} else if (!in_array($aa_filetype, $file_type_whitelist)) {
		return $error = false;
	}
	
}


// delete folder and files associated with ticket
function delete_files($target) {
    if(is_dir($target)){
        $files = glob( $target . '*', GLOB_MARK ); //GLOB_MARK adds a slash to directories returned
        
        foreach( $files as $file )
        {
            delete_files( $file );      
        }
      
        rmdir( $target );
    
	} elseif(is_file($target)) {
    
	    unlink( $target );  
    
	}
	
}


// abbreviate date and time string to time ago
function time_elapsed_string($datetime, $full = false) {
	
	global $lang;
	
	// get date and time of select timezone
	$now = timezone_time();
	// set date and time of object with timezone
    $now = new DateTime($now, new DateTimeZone(get_settings("Timezone")));
    $ago = new DateTime($datetime);
    $diff = $now->diff($ago);

    $diff->w = floor($diff->d / 7);
    $diff->d -= $diff->w * 7;

    $string = array(
        'y' => $lang['dash-activity-year'],
        'm' => $lang['dash-activity-month'],
        'w' => $lang['dash-activity-week'],
        'd' => $lang['dash-activity-day'],
        'h' => $lang['dash-activity-hour'],
        'i' => $lang['dash-activity-minute'],
        's' => $lang['dash-activity-second'],
    );
    foreach ($string as $k => &$v) {
        if ($diff->$k) {
            $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
        } else {
            unset($string[$k]);
        }
    }

    if (!$full) $string = array_slice($string, 0, 1);
    return $string ? implode(', ', $string) . ' '.$lang['dash-activity-ago'] : $lang['dash-activity-now'];
}

// set method for sending email
require '../plugins/phpmailer/PHPMailerAutoload.php';
function aa_send_email($to, $subject, $message) {
	
	$email_method = get_settings("Email_Method");
	
	if ($email_method == 'PHPMAIL') {
	
		$headers = 'From: '.get_settings("Email_Display").' <'.get_settings("Email_Addr").'>' . "\r\n" .
					'Reply-To: '.get_settings("Email_Re_Addr").'' . "\r\n" .
					'MIME-Version: 1.0' . "\r\n" .
					'Content-type: text/html; charset=utf-8' . "\r\n";
		
		$mail_sent = mail($to, $subject, $message, $headers);
		
		// if email fails
		if (!$mail_sent) {
			echo "<p>Failed to send the following email</p>".
				"<p>To: ".$to."</p>".
				"<p>Subject: ".$subject."</p>".
				"<p>Message: ".html_entity_decode($message)."</p>";
		}
	
	} else if ($email_method == 'SMTP') {
		
		$mail = new PHPMailer;
		
		//$mail->SMTPDebug = 3;                               // Enable verbose debug output
		
		$mail->isSMTP();                                      // Set mailer to use SMTP
		$mail->Host = get_settings("Email_SMTP_Host");  // Specify main and backup SMTP servers
		$mail->SMTPAuth = get_settings("Email_SMTP_Auth");                                // Enable SMTP authentication
		$mail->Username = get_settings("Email_SMTP_User");                  // SMTP username
		$mail->Password = get_settings("Email_SMTP_Pass");                           // SMTP password
		$mail->SMTPSecure = get_settings("Email_SMTP_Encr");                           // Enable TLS encryption, `ssl` also accepted
		$mail->Port = get_settings("Email_SMTP_Port");                                   // TCP port to connect to
		
		$mail->From = get_settings("Email_Addr");
		$mail->FromName = get_settings("Email_Display");
		$mail->addAddress($to);     // Add a recipient
		$mail->addReplyTo(get_settings("Email_Re_Addr"));
		//$mail->addCC('cc@example.com');
		//$mail->addBCC('bcc@example.com');
		
		$mail->WordWrap = 50;                                 // Set word wrap to 50 characters
		//$mail->addAttachment('/var/tmp/file.tar.gz');         // Add attachments
		//$mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name
		$mail->isHTML(true);                                  // Set email format to HTML
		
		$mail->Subject = $subject;
		$mail->Body    = $message;
		//$mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
		
		if(!$mail->send()) {
			echo 'Message could not be sent.';
			echo 'Mailer Error: ' . $mail->ErrorInfo;
		} else {
			echo 'Message has been sent';
		}
		
		} // end email method

}


// send email notification of new messages to agents
function send_email_notification_new_ticket($new_ticket_subject, $new_ticket_message) {
	
	$db = db_connect();
	
	global $mysql_users;
	
	$sel_user_new_ticket_not = mysqli_query($db, "SELECT Email FROM $mysql_users WHERE Notify_TN = 1") or die(mysqli_error());;

	while ($u = mysqli_fetch_array($sel_user_new_ticket_not)) {
	
		aa_send_email($u['Email'], $new_ticket_subject, $new_ticket_message);
		
	}
	
}


// send email notification for updated tickets
function send_email_notification_up_ticket($tid) {
	
	$db = db_connect();
	
	global $mysql_users,$mysql_ticket,$mysql_ticket_updates;
	
	$sel_user_up_ticket_not = mysqli_query($db, 
	"SELECT Email, Notes
	FROM $mysql_users AS u
	LEFT JOIN $mysql_ticket AS t ON t.Owner = u.UID
	LEFT JOIN $mysql_ticket_updates AS tu ON t.ID = tu.Ticket_ID
	WHERE t.ID =  '$tid'
	AND u.Notify_TU =1
	ORDER BY tu.Updated_At DESC 
	LIMIT 1") or die(mysqli_error());;

	$u = mysqli_fetch_array($sel_user_up_ticket_not);
	
	aa_send_email($u['Email'], 'Ticket '.$tid.' has been updated', 'Support request '.$tid.' as has been updated by the customer. <p>'.decode_entities($u['Notes']).'</p>');
	
}

// send email notification for private note
function send_email_notification_private_ticket($tid) {
	
	$db = db_connect();
	
	global $mysql_users,$mysql_ticket,$mysql_ticket_updates;
	
	$sel_user_private_ticket_not = mysqli_query($db, "SELECT Email, Owner, Update_By, Updated_At, Notes FROM $mysql_users AS u 
	LEFT JOIN $mysql_ticket AS t ON t.Owner=u.UID
	LEFT JOIN $mysql_ticket_updates AS tu ON t.ID=tu.Ticket_ID
	WHERE t.ID='$tid' AND u.Notify_PM = 1 
	ORDER BY tu.Updated_At DESC LIMIT 1") or die(mysqli_error());;

	$u = mysqli_fetch_array($sel_user_private_ticket_not);
	
	// if update isn't by owner of ticket
	if ($u['Update_By'] != $u['Owner']) {
		aa_send_email($u['Email'], 'Private message added to '.$tid, 'You have been left a private message on ticket '.$tid.'<p>'.decode_entities($u['Notes']).'</p>');
	}
	
}



function send_email_update($tid, $status, $to, $email_content) {

	$db = db_connect();
	
	global $mysql_ticket,$mysql_categories,$mysql_priorities,$mysql_settings;

	$date_format = get_settings("Date_Format");
	$email_method = get_settings("Email_Method");

	if (get_settings("Email_Enabled") == 1) {
	
		switch ($status) {
			case "Open":
				$subject = get_settings("Email_New_Subject");
				$message = get_settings("Email_New_Body");
				break;
			case "Pending":
				$subject = get_settings("Email_Update_Subject");
				$message = get_settings("Email_Update_Body");
				break;
			case "Paused":
				$subject = get_settings("Email_Paused_Subject");
				$message = get_settings("Email_Paused_Body");
				break;
			case "Closed":
				$subject = get_settings("Email_Closed_Subject");
				$message = get_settings("Email_Closed_Body");
				break;
			case "Forward":
				$subject = get_settings("Email_Forward_Subject");
				$message = get_settings("Email_Forward_Body");
				break;
		}
		
		// place code and alternative into array
		$code = array("[TICKET_NO]", "[TICKET_DATE_ADDED]", "[TICKET_DATE_UPDATED]", "[TICKET_SUBJECT]", "[TICKET_ENQUIRY]", "[TICKET_USER]", "[TICKET_UPDATE]", "[TICKET_CATEGORY]", "[TICKET_PRIORITY]");
		
		// select ticket details to be inserted in place of codes
		$ticket_details = mysqli_query($db, "SELECT
										t.ID,
										DATE_FORMAT(t.Date_Added, '$date_format') AS DateAdd,
										DATE_FORMAT(t.Date_Updated, '$date_format') AS DateUp, 
										t.Subject,
										t.User,
										t.Message,
										t.Cat_ID,
										CASE t.Cat_ID WHEN c.Cat_ID THEN c.Category ELSE NULL END Category,
										t.Level_ID,
										CASE t.Level_ID WHEN p.Level_ID THEN p.Level ELSE NULL END Priority
										FROM $mysql_ticket AS t
										LEFT JOIN $mysql_categories AS c ON t.Cat_ID = c.Cat_ID LEFT JOIN $mysql_priorities AS p ON t.Level_ID = p.Level_ID 
										WHERE ID = '$tid'") or die("Problem selecting ticket details");
		$email_ticket = mysqli_fetch_array($ticket_details);
		
		// info to replace codes in order
		$input = array($email_ticket["ID"], $email_ticket["DateAdd"], $email_ticket["DateUp"], html_entity_decode($email_ticket["Subject"]), html_entity_decode($email_ticket["Message"]), $email_ticket["User"], stripslashes($email_content), $email_ticket["Category"], $email_ticket["Priority"]);
		
		// replace codes within subject and message
		$subject = str_replace($code, $input, $subject);
		$message = str_replace($code, $input, $message);
		
		// send email with email function
		aa_send_email($to, $subject, '<div style="display:none; visibility:hidden">---- reply above this line ---</div>'.$message);
				
	} // end if email enabled
	
}


function strip_html_tags( $text )
{
    $text = preg_replace(
        array(
          // Remove invisible content
            '@<head[^>]*?>.*?</head>@siu',
            '@<style[^>]*?>.*?</style>@siu',
            '@<script[^>]*?.*?</script>@siu',
            '@<object[^>]*?.*?</object>@siu',
            '@<embed[^>]*?.*?</embed>@siu',
            '@<applet[^>]*?.*?</applet>@siu',
            '@<noframes[^>]*?.*?</noframes>@siu',
            '@<noscript[^>]*?.*?</noscript>@siu',
            '@<noembed[^>]*?.*?</noembed>@siu',
          // Add line breaks before and after blocks
            '@</?((address)|(blockquote)|(center)|(del))@iu',
            '@</?((div)|(h[1-9])|(ins)|(isindex)|(p)|(pre))@iu',
            '@</?((dir)|(dl)|(dt)|(dd)|(li)|(menu)|(ol)|(ul))@iu',
            '@</?((table)|(th)|(td)|(caption))@iu',
            '@</?((form)|(button)|(fieldset)|(legend)|(input))@iu',
            '@</?((label)|(select)|(optgroup)|(option)|(textarea))@iu',
            '@</?((frameset)|(frame)|(iframe))@iu',
        ),
        array(
            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
            "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0",
            "\n\$0", "\n\$0",
        ),
        $text );
    	
		// do not allow divs as they affect the layout of the page.ticket.php
    	return strip_tags( $text, '<p></p><br><a></a><strong></strong><b></b><em></em><u></u><ul></ul><ol></ol><li></li>' );

}


// security code for adding tickets
function security_code () {

	$no1 = rand(1,10);
	$no2 = rand(1,10);
	
	echo $no1." + ".$no2;
	$_SESSION["code"] = $no1+$no2;
	
}


// count handle tickets on user profile page
function profile_count($status) {

	global $db, $mysql_ticket;
	
	$status = aa_mysqli_escape($status);
	
	$profile_count_tickets = mysqli_query($db, "SELECT * FROM $mysql_ticket WHERE Status = '$status' AND Owner = ".aa_mysqli_escape($_GET["uid"])."") or die("Failed to select profile count SQL");

	$profile_count = mysqli_num_rows($profile_count_tickets);
	
	return $profile_count;
	
}


// generate random password for forgot password
function password_gen() {

	// randomly generate code size
	$str_size = mt_rand(6,12);
	
	// characters to use in code
	$str = "abcdefghijklmnopqrstuvwxyz0123456789";
	
	// split characters into an array
	$str_array = str_split($str);
	
	// generate random keys from the character array up to the random code size
	$rand_keys = array_rand($str_array, $str_size);	

	// loop through character array and random keys until size is reached.
	for ($i = 1; $i <= $str_size; $i++) {
	
		$char = $str_array[$rand_keys[$i]];
		
		$code .= $char;
	
	}
	
	return $code;

}

// get browser name
function getBrowser() 
{ 
    $u_agent = $_SERVER['HTTP_USER_AGENT']; 
    $bname = 'Unknown';
    $platform = 'Unknown';
    $version= "";

    //First get the platform?
    if (preg_match('/linux/i', $u_agent)) {
        $platform = 'linux';
    }
    elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
        $platform = 'mac';
    }
    elseif (preg_match('/windows|win32/i', $u_agent)) {
        $platform = 'windows';
    }

    // Next get the name of the useragent yes seperately and for good reason
    if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)) 
    { 
        $bname = 'Internet Explorer'; 
        $ub = "MSIE"; 
    } 
    elseif(preg_match('/Firefox/i',$u_agent)) 
    { 
        $bname = 'Mozilla Firefox'; 
        $ub = "Firefox"; 
    } 
    elseif(preg_match('/Chrome/i',$u_agent)) 
    { 
        $bname = 'Google Chrome'; 
        $ub = "Chrome"; 
    } 
    elseif(preg_match('/Safari/i',$u_agent)) 
    { 
        $bname = 'Apple Safari'; 
        $ub = "Safari"; 
    } 
    elseif(preg_match('/Opera/i',$u_agent)) 
    { 
        $bname = 'Opera'; 
        $ub = "Opera"; 
    } 
    elseif(preg_match('/Netscape/i',$u_agent)) 
    { 
        $bname = 'Netscape'; 
        $ub = "Netscape"; 
    } 

    // finally get the correct version number
    $known = array('Version', $ub, 'other');
    $pattern = '#(?<browser>' . join('|', $known) .
    ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
    if (!preg_match_all($pattern, $u_agent, $matches)) {
        // we have no matching number just continue
    }

    // see how many we have
    $i = count($matches['browser']);
    if ($i != 1) {
        //we will have two since we are not using 'other' argument yet
        //see if version is before or after the name
        if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
            $version= $matches['version'][0];
        }
        else {
            $version= $matches['version'][1];
        }
    }
    else {
        $version= $matches['version'][0];
    }

    // check if we have a number
    if ($version==null || $version=="") {$version="?";}

    return array(
        'userAgent' => $u_agent,
        'name'      => $bname,
        'version'   => $version,
        'platform'  => $platform,
        'pattern'    => $pattern
    );
} 
?>