function aa_dashboard_summary() {
	
	timer = setInterval(function(){
		$.ajax({ 
			url: "ajax.dashboard_summary.php",
			type: "POST",
			cache: false,	
			async: false,
			success: function(data){
				
				$("#dashboardsum").html(data);
				
				aa_dashboard_summary_filter()
				
			},
			error: function(err) {
				$("#dashboardsum").html(err);
			}
		});
	}, 5000);
	
}

function aa_dashboard_summary_filter() {
$( "#dashboardsum .summary_block" ).click(function() {

	var group = $(this).attr("group");
	var status = $(this).attr("status");
			
	//alert (status);
	$.ajax({
		url: "ajax.dashboard_push_filter.php",
		type: "post",
		data: { 'p_group' : group, 'p_status' : status },
		cache: false,
		async: false,
		success: function(data){
			//alert("Success" + data);
			window.location.href = 'page.php?page=page.tickets';
		},
		error:function(){
			alert("Failed to redirected to tickets page");
		}
	});

});
}


// check chats for new or pending
function aa_chats(){
		
	timer = setInterval(function(){
		$.ajax({ 
			url: "ajax.chats.php",
			type: "POST",
			cache: false,	
			success: function(chatdata){
				
				$("#livechat, #aa_chats").html(chatdata); // set html to header and aachats on page.chat
				
				// set icon color if online or offline
				var aachat_agent_status = $("#aachat-agent-status").val();
				if (aachat_agent_status < 1) {
					$("#open_aachat .fa").css("color", "red");
				} else {
					$("#open_aachat .fa").css("color", "#78c846");
				}
				
				var aachat_newchats_no = $("#aachat-new-status").val(); // no of new chats in hidden input
				var aachat_newchats_values = $("#aa-chat-new-values").html(); // new chats html
				var aachat_newchats_new = localStorage.getItem('aachat_newalerts'); // get localstorage of new chats

				var aachat_pendingchats_no = $("#aachat-pending-status").val(); // no of pending chat messages in hidden input
				
				if (aachat_newchats_no > 0) {
					
					// blink page title for new messages
					setTimeout(function(){
						var title = document.title;
						document.title = (title == "Acorn Aid Admin" ? "New chat message" : "Acorn Aid Admin");
					}, 250);
					
					// show red notification box for new chat
					$("#aachat_notification").css("display","block").html(aachat_newchats_no);
					
					// play new chat sound if number of new chats is greater than 1
					if (aachat_newchats_values != aachat_newchats_new) {
						$('#alertAudio')[0].play();
						localStorage.setItem('aachat_newalerts', aachat_newchats_values); // set localstorage for new chats
					}
					
				} else if (aachat_pendingchats_no >= 1) {
					$("#aachat_notification").css("display","block").html(aachat_pendingchats_no);
				} else { // if pending chat messages is zero then hide notification box
					$("#aachat_notification").css("display","none");
				}
				
				
			},
			error: function(err) {
				$("#livechat").html(err);
			}
		});
	}, 1500); // time equal to timeout between vistor and agent
	
}


// functions outside of document ready for single page usage
// load ticket table	
function ticket_table_load(position) {
	var values = $("#auto-filter-form").serializeArray();

	if (position == "updates") {
		
		var now = new Date(); 
		var datetime = now.getFullYear()+'-'+(now.getMonth()+1)+'-'+now.getDate(); 
		datetime += ' '+now.getHours()+':'+now.getMinutes()+':'+now.getSeconds(); 

		values.push({name:'dt', value: datetime});
		
	}
	
	$.ajax({
		url: "ajax.tickets.php",
		type: "post",
		data: values,
		cache: false,
		success: function(ticketdata){

			if (position == "begin") {

				$("#tickets").html(ticketdata);

			} else if (position == "updates") {
			
				$("#tickets").prepend(ticketdata);
			 
			}
			
			// checkbox to localstorage
			if (window.localStorage) {
			
				// select all tickets
				$(function(){
				   $('#select-all').click(function(event) {   
						if(this.checked) {
							// Iterate each checkbox
							$('.checkbox:checkbox').each(function() {
								this.checked = true;   
								localStorage && localStorage.setItem(this.id,'checked');				                     
							});
						}
						if(!this.checked) {
							// Iterate each checkbox
							$('.checkbox:checkbox').each(function() {
								this.checked = false;  
								localStorage && localStorage.removeItem(this.id);			                      
							});
						}
					});
				});
				
				// on class checkbox change
				$('.checkbox').change(function() {
					// set array and check
					var name = this.id;
					var value = this.value;
							
					// if checked
					if ($(this).is(':checked')) {
			
						//shorthand to check that localStorage exists	
						localStorage && localStorage.setItem(this.id,'checked');	
						
					} else {
						
						//shorthand to check that localStorage exists
						localStorage && localStorage.removeItem(this.id);		
					
					}
					
				});
				
				$('.checkbox:checkbox').each(function() {
					
					$(this).prop('checked',localStorage.getItem(this.id) == 'checked');
					
				});
			
			}	
			
			// functions within tickets load and refresh
			$('.open').css({"background-color": "#78c846"});
			$('.pending').css({"background-color": "#4678C8"});
			$('.paused').css({"background-color": "#C89646"});
			$('.closed').css({"background-color": "#c84678"});
						
			$( ".ticket" ).click(function(e) {
				var tid = this.id;			
				e.stopPropagation();
				window.open( "page.php?page=page.ticket&tid=" + tid, "_self" );
				
				});
				
				$( ".ticket input:checkbox" ).click(function(e) {
							
				e.stopPropagation();
						
			});
			
			
		}

	});
				
}

// check for updates every 15 seconds

function refreshtickets() {
	ticketrefresh = setInterval(function(){
		ticket_table_load("updates");
	},15000);
}
// end functions

// start document ready
$(document).ready(function() {
	
	$("#sidebar, #livechat").css("display","none");

	function mobile_navigation() {
		
		var current_window_width = $( window ).outerWidth();
		
		// if mobile/pad then hide sidebars and filters
		if (current_window_width <= 960) {	
			
			$("#body").removeClass( "body_slide" , 500 );
			$("#sidebar").css("display","none");
			$("#inner-body-left").css("display","none");
			
			$("#qsearch").insertAfter("#mobile-search");
			// move body right to below header e.g. ratings
			$( "#body-right" ).insertAfter("#table_header");

		// if desktop show filters
		} else {
			
			if ($("#sidebar").is(':visible')) {
			$("#sidebar").css("display","block");
			} else {
			$("#body").removeClass( "body_slide" , 500 );
			}
			
			$("#inner-body-left").css("display","block");
			
			$("#qsearch").insertAfter("#title");
			// move body right back to typical position
			$( "#body-right" ).insertAfter("#body-middle");

		}
		
	}
	
	// run function on page load
	mobile_navigation();
    var width = $(window).width();
    $(window).resize(function(){
        if($(window).width() != width){
            
			mobile_navigation();
			
            width = $(window).width();
        }
    });
	
	
	$("#open").click(function() {
		// if absolute then mobile/pad view
		if ($("#inner-body-left").css('position') == 'absolute') {
			
			// if visible hide
			if ($("#inner-body-left").is(':visible')) {
		
				$("#inner-body-left").css("display","none");
		
			} else {
				
				$("#body").toggleClass( "body_slide" , 250 );
			
			}
			
		} else {
		
			$("#body").toggleClass( "body_slide" , 250 );
		
		}

		var current_window_width = $( window ).outerWidth();
		var current_window_height = $( document ).outerHeight(); // removed -60 due to mobile nav bug
		// if mobile/pad then hide sidebars and filters
		if (current_window_width <= 960) {	
			
			if ($("#livechat").is(':visible')) {
				$("#livechat").css("display","none");
				$("#body").removeClass( "body_slide" );	
			}
			
			$("#sidebar").height(current_window_height);
			$("#sidebar").toggle( "slide", {direction : "right" }, 250 );
				
		} else {
			
			$("#sidebar").toggle( "slide", {direction : "up" }, 250 );

		}
		
	});
		
	
	$("#open-filter").click(function() {
		
		// if menu is open, close it
		if ($("#sidebar").is(':visible')) {
		$("#sidebar").css("display","none");
		$("#body").toggleClass( "body_slide" , 250 );
		}
		
		var current_window_height = $( document ).outerHeight();
		$("#inner-body-left").height(current_window_height+'px');
		$("#inner-body-left").toggle( "slide", {direction : "right" }, 500 );
		
	});
	
	$("#filter-close").click(function() {
		$("#inner-body-left").toggle( "slide", {direction : "right" }, 500 );		
	});
	
		
		
	// enable and disable inputs on tick box 
	$("#input_enable").click(function() {
		$(".dis-enl-input").prop("disabled", !$(".dis-enl-input").prop("disabled"));
    });
	
	if ($("#input_enable").is(':checked')) {
		$(".dis-enl-input").prop("disabled", false);
    } else {
		$(".dis-enl-input").prop("disabled", true);
	}
	// end of input enable/disable
	
	// smtp options
	$("#smtp_options").hide();
	if ($("#input_smtp").is(':checked')) {
			
		$("#smtp_options").show();
	
	}
	
	$('#ticket_view_header').hide();

	
	// toggle smtp options
	$("#input_phpmail").click(function() {
		$("#smtp_options").hide();								
	});
	$("#input_smtp").click(function() {
		$("#smtp_options").fadeIn();								
	});
	
	
	// custom fields page
	function show_options () {
		
		var type = $("#custom_type").val();
		
		if (type == "Text" || type == "Textbox") {
			
			$("#custom_options").hide();
			$("#custom_maxlen").show();
			
		} else if (type == "Select" || type == "Radio" || type == "Checkbox") {

			$("#custom_maxlen").hide();
			$("#custom_maxlen_input").val("0");
			$("#custom_options").show();		
		}
		
	}

	show_options();
	// end custom  fields page
	
	// ticket add page for extra file uploads
	$( "#addfile" ).click(function() {
		
		var no_of_files = $('.aafile').length
		var aafilelimit = $('#aafilelimit').val();
		
		if (no_of_files == aafilelimit) {
			alert ('No more file attachments allowed');
		} else {
			$( "#fileuploads" ).append( "<p class=\"label_checkbox\"><input class=\"aafile\" name=\"file[]\" type=\"file\" /></p>" );
		}
		return false;
		
	});
	// end ticket add page


	// on filter form change
	$("#custom_type").change(function(event) {
											
		event.preventDefault();	
		show_options();
	});
	
	$(".delete_field").click(function() {
	var status = confirm("Any previous information associated with this field will be deleted.\n\nDo you wish to continue?");
		if(status == false){
			return false;
		} else {
			location.reload();
		}
	});
	
	// end of custom fields page
	
	// canned replies settings page
	
	$(".can_edit").click(function(event) {

		event.preventDefault();
		var $body = $(tinymce.activeEditor.getBody());
		
		canid = $(this).attr("canid");
		cantitle = $(this).attr("cantitle");
		canmsg = $(this).attr("canmsg");

		$("#can_id").val(canid);
		$("#can_title").val(cantitle);
		$body.html($('<span>' + canmsg + '</span>'));
	
	});
		
	// end of canned replies setting page
	
	
	// tickets page
	
	// set select2 to select boxes in tickets and ticket
	$("#filter_date,#filter_status,#filter_group,#chg_status,#chg_cat,#chg_priority,#chg_owner,#ticket_view").select2({
			containerCssClass: "select2-border",	
	});
	
	// hide search page from view by select in tickets page
	$("#ticket_view").select2({
    	minimumResultsForSearch: -1
	});
	
	
	$("#can_reply").select2({
	placeholder: "Select canned reply"
	});

	// function to reload table after change

	
	// set hidden sort fields to visible sort fields on page load. Used for session variables
	var sortdir = $("#sortdir").val();
	$("#filter_sortdir").val(sortdir);
	var sortval = $("#sortval").val();
	$("#filter_sortval").val(sortval);
		
	// get emails
	$( '#getemails').click(function() {
				
		$('#tickets').html('<p class="center">Getting emails</p><p class="center"><i class=\"fa fa-spinner fa-spin\"></p>');
		$.ajax({
			url: "cron.emailmessage.php",
			type: "post",
			cache: false,
			success: function(data){
				location.reload();				
			},
			error:function(){
				alert("Failed get emails");
			}
		});

	})
	
	// change ticket status
	$( '#chg' ).click(function( e ) {
	
		e.preventDefault();
		
		// set array variable			
		var selected = new Array();
		var selectval = $( "#chg_field" ).val();
		var update = $( "#chg_val" ).val();
			
		// foreach checkbox cheked pushed into array
		$("input:checkbox[name=checked_ticket]:checked").each(function() {
			// push data into array  
			selected.push($(this).val());			
			
		});

		// post selected array and uid to php page
		$.post( "ajax.tickets_update.php", { tid : selected, field : selectval, changeto : update } , function(data){

			// resend variables		
			values = $("#auto-filter-form").serializeArray();
			/* Send the data using post and put the results in a div */
			ticket_table_load("begin");
			$('#select-all').prop('checked', false); 
					
		});
		localStorage.clear();
			
	});	

	// on filter form change
	$(".auto-ticket-filter").change(function(event) {
					
		// ensure one user is selected
		var count_user = $("[name='user[]']:checked").length;

        if(count_user == 0) 
        {
            //alert("Please select any record to delete.");
            $(this).prop('checked', true);
			return false;
        }
								
		event.preventDefault();
		
		values = $("#auto-filter-form").serializeArray();
				
		// post filter to tickets
		/* Send the data using post and put the results in a div */
		ticket_table_load("begin");
		
	});
	
	// on visible sort change, change the hidden values
	$("#sortval").change(function (ve) {
	
		var sortval = $("#sortval").val();
		
		$("#filter_sortval").val(sortval);
			
		$('#auto-filter-form').trigger('change');	
				
	});
	// on visible sort change, change the hidden values
	$("#sortdir").change(function (ve) {
	
		var sortdir = $("#sortdir").val();
		
		$("#filter_sortdir").val(sortdir);
			
		$('#auto-filter-form').trigger('change');	
				
	});	
	
	// reset filter form by clearing the sessions
	$("#filter-reset").click(function() {

		$.ajax({
			url: "ajax.tickets_reset_filter.php",
			type: "post",
			cache: false,
			success: function(data){
				location.reload();				
			},
			error:function(){
				alert("Failed to reset filter form");
			}
		});
		
	});
	// end tickets page
	
	
	// functions on ticket page
	// on clicking accept ticket	
	
	$("#accept").click(function() {
	
	var tid = $('#tid').attr('tid');
	var uid = $('#tid').attr('uid');
			
			$.ajax({  
				url: "ajax.ticket_accept.php",
				data: {p_tid: tid, p_uid: uid},
				type: 'POST',  
				cache: false,  
				success: function(data) {		
					
					location.reload();
										
				},
			
			});
			
	});
	
	
	// open chat window
	$("#open_aachat").click(function() {

		var current_window_width = $( window ).outerWidth();
		var current_window_height = $( document ).outerHeight();
		if (current_window_width <= 960) {	
			
			// if menu is open, close it
			if ($("#sidebar").is(':visible')) {
				$("#sidebar").css("display","none");
			} else {
				$("#body").toggleClass( "body_slide" , 250 );
			}
			$("#livechat").height(current_window_height);
			$("#livechat").toggle( "slide", {direction : "right" }, 250 );		
			
		} else {
			
			$("#livechat").toggle( "slide", {direction : "up" }, 250 );			

		}

			
	});
	
	// accept chat
	$("#aachat-accept").click(function() {
	
	var tid = $('#tid').attr('tid');
	var uid = $('#tid').attr('uid');
			
		$.ajax({  
			url: "ajax.chat_accept.php",
			data: {p_tid: tid, p_uid: uid},
			type: 'POST',  
			cache: false,  
			success: function(data) {		
				
				location.reload();
									
			},
		
		});
			
	});	
	
	// agent close chat
	$("#aachat-done").click(function() {

	var cid = $('#tid').attr('tid');
	var uid = $('#tid').attr('uid');

		$.ajax({  
			url: "ajax.chat_closed.php",
			data: {p_cid: cid, p_uid: uid},
			type: 'POST',  
			cache: false,  
			success: function(data) {		
				
				location.reload();
									
			},
		
		});
		
	});


	// on clicking on trash can
	$("#delete").click(function() {
		
		if (confirm('Are you sure you want to delete this ticket?')) {
			var tid = $('#tid').attr('tid');
			var filefolder = $('#tid').attr('filefolder');
			
				$.ajax({  
					url: "ajax.ticket_delete.php",
					data: {p_tid: tid, p_filefolder: filefolder},
					type: 'post',  
					cache: false,  
					success: function(data) {		
					//alert (data);
					window.location.href = 'page.php?page=page.tickets';
					},
					error:function(){
					alert ( "Failed to delete ticket" );
					}
				
				});
		
		}

	});
	
	// clear eidtable content local storage each time the ticket page loads.
	localStorage.removeItem("aa_editbefore");
	// on clicking the pencil to edit
	$(".click_editable").click(function() {

		var closet = $(this).nextAll(".editable:first");
		// allow editable content to be ediatable. E.g. allow clcik of links
		closet.attr("contenteditable","true");		
		closet.focus();
		return false;
		
	});
			
	
	//  on editting ticket
	$(".editable").focus(function() {
		var editbefore = $(this).html();
		localStorage.setItem('aa_editbefore', editbefore);	
	});


	// on exiting editting ticket
	$(".editable").focusout(function() {

		var tid = $(this).attr("tid");
		var type = $(this).attr("type");

		var editbefore = localStorage.getItem('aa_editbefore');
		var editafter = $(this).html();

		if (editbefore != null) {

			if (editbefore !== editafter) {
				
				var saveeidt = confirm("Save changes?");
				
				if(saveeidt == false){
					
					$(this).html(editbefore); // revert text back to before
					
				} else {
					
					$.ajax({  
						url: "ajax.ticket_edit.php",
						data: {p_tid: tid, p_type: type, p_edit: editafter},
						type: 'POST',  
						cache: false,
						error: function(data) {		
							alert("Failed to save edit");
						},
					
					});
					
				}
			
			}
		
		}
		
		// set content editable to be false
		$(this).attr("contenteditable","false");	
				
	});	
	

	// on deleting a single post
	$(".click_delete").click(function() {
									  
		if (confirm('Are you sure you want to delete this ticket update?')) {
			var tuid = $(this).attr("tid");
	
			$.ajax({  
				url: "ajax.ticket_update_delete.php",
				data: {p_tuid: tuid},
				type: 'POST',  
				cache: false,
				success: function(data) {		
					$("#"+tuid).fadeOut();
				},
			
			});
			return false;
		}

	});


	$( "#can_reply" ).change(function() {
	
		var canmsg = $(this).val();
		
		var $body = $(tinymce.activeEditor.getBody());
		
		$body.append($('<span>' + canmsg + '</span>'));

	});
	
	
	// show / hide forward toggle
	$("#aa_forward_to").hide();
	$("#aa_forward_toggle").click(function () {
		$("#aa_forward_to").toggle();
		return false;
	});	


	// open the popup window
	$(".open_popup").click(function(){

	var popup_func = $(this).attr("popup_func");
	var popup_id = $(this).attr("popup_id");
			
	$(".overlay, .popup").fadeToggle();
		
	});
	
	// close the popup window
	$(".overlay, .close_popup").click(function(){
		
		$( ".overlay" ).hide();
		$( ".popup" ).hide();
			
	});
	
	
	// popup window change password on user profile page
	$("#password_chg").click(function(event){
		
		var uid = $("#user_id").val();
		var newpwd = $("#newpwd").val();
		var confirmedpwd = $("#confirmpwd").val();
			
		if (newpwd == "" || confirmedpwd == "") {
			
			$("#pwd_result").html( "<span class='error'>! You must enter your password in both fields.</span>" );
				
		} else if (newpwd != confirmedpwd) {
		
			$("#pwd_result").html( "<span class='error'>! Your new passwords don't match. Try again.</span>" );

		} else if (newpwd.length < 6) {
			
			$("#pwd_result").html( "<span class='error'>! Your new password must be longer than 6 characters.</span>" );
			
		} else {
			
			$.ajax({
				url: "ajax.pwchange.php",
				type: "post",
				data: { user : uid, new_pwd : newpwd },
				cache: false,
				success: function(pwchgdata){
					$("#pwd_result").html( "<div class=\"success\">" + pwchgdata + "</div>" );
					$('#profile_pw_change').trigger("reset");
				},
				error:function(){
					$("#pwd_result").html( pwchgdata );
				}
			});
				
		}
		
		return false;
		
	});
	
	
	// on ticket search
	$("#merge_search").click(function(event){
		var merge_input = $("#merge_input").val();
		var tid = $('#tid').attr('tid');
		tid = tid*1; // strip leading zeros off by * by 1.

		if (tid == merge_input) {
			
			$("#merge_results").html( "<div id=inner_merge_results>Ticket cannot be joined to itself</div>" );
			
		} else {
			
			$.ajax({
				url: "ajax.merge_results.php",
				type: "post",
				data: { from_tid : tid, merge_data : merge_input },
				cache: false,
				success: function(mergedata){
					$("#merge_results").html( mergedata );
				},
				error:function(){
					$("#merge_results").html( "Search failed" );
				}
			});
			
		}
		// prevent popup from closing
		return false;

	});	
	// end ticket page functions
	
	// search function
	$("#qs_error").hide();	
	
	// submit quick search form
	$("#search_quick").submit(function(qs) {
		
		qs.preventDefault();
		
		var qs_input = $("#search_input").val();
		
		if (!qs_input) {
			
			$("#search_input").css({ "border": "1px solid #FF0000" });
			$("#search_input").focus();
			
		} else {
			
			window.open( "page.php?page=page.search&search=" + qs_input, "_self" );
		
		}
		
	});
	// end search function
	
	
	// search results page
	$('.open').css({"background-color": "#78c846"});
	$('.pending').css({"background-color": "#4678C8"});
	$('.paused').css({"background-color": "#C89646"});
	$('.closed').css({"background-color": "#c84678"});

	// function for turning table tr into link and ignoring checkboxes
	$(function() {
		
		$( ".ticket" ).click(function() {
		
		var tid = this.id;			
		//alert ( cid );
		window.open( "page.php?page=page.ticket&tid=" + tid, "_self" );
		
		});
		
	});
	
	// date picker
	$(function() {
		
		$( "#adv_s_dateadd_from" ).datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		numberOfMonths: 1,
		onClose: function( selectedDate ) {
		$( "#adv_s_dateadd_to" ).datepicker( "option", "minDate", selectedDate );
		}
		});
		
		$( "#adv_s_dateadd_to" ).datepicker({
		dateFormat: "yy-mm-dd",	
		changeMonth: true,
		numberOfMonths: 1,
		onClose: function( selectedDate ) {
		$( "#adv_s_dateadd_from" ).datepicker( "option", "maxDate", selectedDate );
		}
		});
		
		$( "#adv_s_dateup_from" ).datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		numberOfMonths: 1,
		onClose: function( selectedDate ) {
		$( "#adv_s_dateup_to" ).datepicker( "option", "minDate", selectedDate );
		}
		});
		
		$( "#adv_s_dateup_to" ).datepicker({
		dateFormat: "yy-mm-dd",	
		changeMonth: true,
		numberOfMonths: 1,
		onClose: function( selectedDate ) {
		$( "#adv_s_dateup_from" ).datepicker( "option", "maxDate", selectedDate );
		}
		});	
	
		$( "#adv_s_dateclosed_from" ).datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		numberOfMonths: 1,
		onClose: function( selectedDate ) {
		$( "#adv_s_dateclosed_to" ).datepicker( "option", "minDate", selectedDate );
		}
		});
		
		$( "#adv_s_dateclosed_to" ).datepicker({
		dateFormat: "yy-mm-dd",	
		changeMonth: true,
		numberOfMonths: 1,
		onClose: function( selectedDate ) {
		$( "#adv_s_dateclosed_from" ).datepicker( "option", "maxDate", selectedDate );
		}
		});	
	
	});
	
	// value of each search criteria to be used in result string
	var search_vals = {};
	search_vals["ID"] = $("#adv_s_tid").val();
	search_vals["Subject"] = $("#adv_s_subject").val();
	search_vals["Message"] = $("#adv_s_msg").val();
	search_vals["Customer"] = $("#adv_s_cust").val();
	
	search_vals["Group"] = $("#adv_s_group option:selected").text();
	search_vals["Status"] = $("#adv_s_status option:selected").text();
	search_vals["Priority"] = $("#adv_s_priority option:selected").text();
	search_vals["Owner"] = $("#adv_s_owner option:selected").text();
	
	search_vals["Date Added From"] = $("#adv_s_dateadd_from").val();
	search_vals["Date Added To"] = $("#adv_s_dateadd_to").val();
	search_vals["Date Updated From"] = $("#adv_s_dateup_from").val();
	search_vals["Date Updated To"] = $("#adv_s_dateup_to").val();
	search_vals["Date Closed From"] = $("#adv_s_dateclosed_from").val();
	search_vals["Date Closed To"] = $("#adv_s_dateclosed_to").val();
	
	var blkstr = $.map(search_vals, function(val,index) {
		if (val) {                    
		 var str = "<b>" + index + "</b>" + ": " + val;
		}
		 return str;
		
	}).join(", "); 
	
	$("#search_criterea").html( blkstr);
	// end search page results
	
	
	// functions on report page
	
	// set tr as hidden
	if ($("#report_set_period option:selected").val() == 'custom') {
		$("#report_custom_dates").show();
	} else {
		$("#report_custom_dates").hide();
	}
	
	function aa_report_type() {
		var rtype = $("#report_type").val();
		if (rtype !== 'ticket_summary' && rtype != 'time_spent') {
			$("#report_groupby_div").hide();
		} else {
			$("#report_groupby_div").show();
		}
	}
	
	aa_report_type();
	// show and hide group by option
	$('#report_type').change(function(){
		aa_report_type();
	});
	
	// show and hide custom date fields
	$('#report_set_period').change(function(){
	
		if($(this).val() == 'custom'){ // or this.value == 'volvo'
		
			$("#report_custom_dates").show();
		
		} else {
		
			$("#report_custom_dates").hide();
		
		}
	
	});
	
	// date picker
	$(function() {
		
		$( "#rep_period_from" ).datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		numberOfMonths: 1,
		onClose: function( selectedDate ) {
		$( "#rep_period_to" ).datepicker( "option", "minDate", selectedDate );
		}
		});
		
		$( "#rep_period_to" ).datepicker({
		dateFormat: "yy-mm-dd",	
		changeMonth: true,
		numberOfMonths: 1,
		onClose: function( selectedDate ) {
		$( "#rep_period_from" ).datepicker( "option", "maxDate", selectedDate );
		}
		});
	
	});
	
	// end of functions on report page


	// user pages
	$('#u-show-ticket-detail').click(function() {
	
		$('.u-ticket-detail').toggle();
	
	});	
	
	$('.kb_cont').each(function(){  
	
	var highestBox = 0;
	$('.kb', this).each(function(){
	
		if($(this).height() > highestBox) 
		   highestBox = $(this).height(); 
		});  
	
	$('.kb',this).height(highestBox);
	
	}); 
	
	// user ticket rating
	$( "#rating li" ).click(function() {
	
	var rating_value = $(this).attr("rval");
	var tid = $("#ticket_values").attr("ticket_id");
	var uid = $("#ticket_values").attr("user_id");

		$.ajax({
			url: "ajax.ticket_rate.php",
			type: "post",
			data: {rating: rating_value, ticket_id: tid, ticket_user: uid},
			cache: false,
			success: function(data){
				// refresh page
				window.location.reload();
			},
			error:function(){
				alert("Failed to rate ticket");
			}
		});
	
	});
	
	// copyright notice
	var acornaid_footer = $("#footer-inner").html("<p>Powered by <a href=\"http://www.acornaid.com\" target=\"_blank\">Acorn Aid</a></p>");
	
	if ($("#footer-inner").not(":contains('Acorn')").length == 1) {
		
		acornaid_footer;

	} else if ($("#footer-innner").children().css('visibility') == 'hidden') {
		
		acornaid_footer;
		
	} else if ($("#footer-inner").children().css('display') == 'none') {
		
		acornaid_footer;

	}	
	
	
});
	
