<?php
// if tracking button clicked
if (isset($_POST["track_submit"])) {
	
	// run custom function to clean email and ticket number fields
	$email = form_field_clean($_POST["track_email"], TRUE);
	$ticketno = form_field_clean($_POST["track_ticketno"], TRUE);
	
	// set db variable
	$db = db_connect();
	
	// select ticket where email and ticket id match ticket in database
	$check_tracking = mysqli_query($db, "SELECT ID, User_Email FROM $mysql_ticket WHERE User_Email = '$email' AND ID = '$ticketno'");
	// count returned tickets for checking
	$valid_entry = mysqli_num_rows($check_tracking);
	
	// check for empty fields
	if ($email == "" || $ticketno == "") {
		
		$track_error = $lang['u-ticket-track-error-req'];
	
	// check for valid email
	} else if (form_validate ("EMAIL", $email) === TRUE) {
				
		$track_error = $lang['u-ticket-track-error-inv-em'];
	
	// check ticket no is numeric	
	} else if (form_validate ("NUMBER", $ticketno) === TRUE) {
				
		$track_error = $lang['u-ticket-track-error-inv-no'];
	
	// check if email and ticket number entered are valid from mysql check	
	} else if ($valid_entry == 0) {
		
		$track_error = $lang['u-ticket-track-error-not-found'];
		
	}
	
	// if no errors then show ticket details			
	if (!isset($track_error)) {

		header("Location: index.php?p=p.ticket&email=".$email."&tid=".$ticketno."");

	}

}
?>
<div class="margin-body" style="clear:both">
    
   		<h2><?php echo $lang['u-ticket-track-title']; ?></h2>
        
        <form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post" id="track">
            <?php 
            if (isset($track_error)) {
                echo "<p><span class=\"error\">".$track_error."</span></p>";
            }
            ?>
            <label><?php echo $lang['u-ticket-track-t-em']; ?></label>
            <input class="tracking_inputs" name="track_email" type="text" placeholder="<?php echo $lang['u-ticket-track-t-em']; ?>" value="<?php if(isset($email)) { echo $email; } ?>"/>
          <label><?php echo $lang['u-ticket-track-t-no']; ?></label>
          <input class="tracking_inputs" name="track_ticketno" type="text" placeholder="<?php echo $lang['u-ticket-track-t-no']; ?>" value="<?php if(isset($ticketno)) { echo $ticketno; } ?>"/>
          <p><input class="tracking_inputs" name="track_submit" type="submit" value="<?php echo $lang['u-ticket-track-submit']; ?>" /></p>
        </form>
        
</div>
