<?php

// set variables from get variables
$tid = aa_mysqli_escape($_GET["tid"]);
$email = aa_mysqli_escape($_GET["email"]);

if (!isset($_GET["tid"])) {

	header('Location: index.php?p=p.ticket-track');
	
}


// set date format from settings
$date_format = get_settings('Date_Format');
$allow_feedback = get_settings("Ticket_Feedback");

// create path to delete folder and files with ending slash
$file_path = get_settings("File_Path");
$file_folder = ltrim($tid, '0');
$files_to_delete = $file_path.$file_folder;

// select the original ticket details where ticket equals id and email
$sel_ticket = mysqli_query($db, "SELECT
								t.*,
								t.ID, 
								t.Subject,
								t.User,
								t.Status,
								DATE_FORMAT(t.Date_Added, '$date_format') AS DateAdd,
								DATE_FORMAT(t.Date_Updated, '$date_format') AS DateUp,
								t.Cat_ID,
								CASE t.Cat_ID WHEN c.Cat_ID THEN c.Category ELSE NULL END Category,
								t.Level_ID,
								t.Message,
								CASE t.Level_ID WHEN p.Level_ID THEN p.Level ELSE NULL END Priority,
								t.Owner,
								t.Feedback,
								(CASE WHEN t.Owner IS NULL THEN 'Unassigned' ELSE CONCAT(u.Fname, ' ' ,u.Lname) END) AS Owned,
								(CASE WHEN t.Date_Closed IS NULL THEN 'N/A' ELSE DATE_FORMAT(t.Date_Closed, '$date_format') END) AS DateClosed,
								(CASE WHEN t.Date_Replied IS NULL THEN 'N/A' ELSE DATE_FORMAT(t.Date_Replied, '$date_format') END) AS DateReplied
								FROM $mysql_ticket AS t
								LEFT JOIN $mysql_categories AS c ON t.Cat_ID = c.Cat_ID 
								LEFT JOIN $mysql_priorities AS p ON t.Level_ID = p.Level_ID
								LEFT JOIn $mysql_users AS u ON u.UID=t.Owner
								WHERE ID = '$tid' AND User_Email = '$email'");
$ticket = mysqli_fetch_array($sel_ticket);

// get number of rows for validation on ticket updates.
$ticket_no_rows = mysqli_num_rows($sel_ticket);

// if record exists above then show updates associated with tid
if ($ticket_no_rows > 0) {
	
	$sel_ticket_updates = mysqli_query($db, "SELECT tu.*, DATE_FORMAT(tu.Updated_At, '$date_format') AS DateUp, u.*
											FROM $mysql_ticket_updates AS tu
											LEFT JOIN $mysql_users AS u ON u.UID=tu.Update_By
											WHERE (tu.Ticket_ID = '$tid') AND (tu.Update_Emailed = 1)  ORDER BY tu.Updated_At ASC");

} else {

	header('Location: index.php?p=p.ticket-track');

}
	

// if sql column is populated with files
if ($ticket["Files"] != "") {
	$files = rtrim($ticket["Files"], ",");
	$file_array = explode(",",$files);
	$file_count = count($file_array);
} else {
	$file_count = 0;
}

// submit reply
if (isset($_POST["user_submit"])) {
	
	$tid = aa_mysqli_escape($_GET["tid"]);
	$reply = form_field_clean($_POST["user_update"], FALSE);

	// apply no formatting to email message for plain text to be held
	$email_format_reply = $_POST["user_update"];
			
	$files = $_FILES["file"];
	// upload directory
	$file_upload_dir = get_settings("File_Path");
	$file_tid_folder = ltrim($tid,"0");
	// allowed file size
	$allowed_file_size = get_settings("File_Size");	
	// get number of files attached -1 for array to begin at 0
	$arraysize = count($files["name"])-1;
	
	$form_error = array();
	
		// check name
		if (form_validate ("TEXT", $reply) === TRUE) {
				
			$form_error['REPLY'] = $lang["generic-error"];
				
		} 
		
		$files = $_FILES["file"];
		$no_of_files = count($_FILES["file"]["name"]);	
		
		for ($f = 0; $f < $no_of_files; $f++) {
			if (!empty($_FILES["file"]["name"][$f])) {	
			
				if(aa_validate_files($_FILES["file"]["name"][$f], $_FILES["file"]["size"][$f]) === false) {
					$form_error['FILE'] = $lang['generic-file-size-exc'].
										"<br />".$lang['generic-file-size-rule']." ".(get_settings("File_Size") / 1048576)."MB".
										"<br />".$lang['generic-file-type-rule']." ".get_settings("File_Type");
					break;
				} else {
					@$aa_files .= $_FILES["file"]["name"][$f].",";
				}
				
			}
		}
		
		// if no errors
		if (empty($form_error)) {
			// set date format from settings
			$now = aa_mysqli_escape(timezone_time());
			
			mysqli_query($db, "INSERT INTO $mysql_ticket_updates (Ticket_ID, Update_By, Updated_At, Update_Type, Notes, Update_Files, Update_Emailed) VALUES ('$tid', '$ticket[User]', '$now', 'Update', '$reply', '$aa_files', 1)") or die(mysql_error());  
			
			// set update ticket
			mysqli_query($db, "UPDATE $mysql_ticket SET Status = 'Pending', Date_Updated = '$now' WHERE ID = '$tid'");
				
			// if file has been uploaded upload each file
			if (!empty($files["name"][0])) {

				// loop through each attachement and upload
				for ($key = 0; $key <= $no_of_files; $key++) {
				
					if (!is_dir($file_path.$file_folder)) {
    					@mkdir($file_path.$file_folder);
					}
					
					// move each uploaded file to folder
					move_uploaded_file($files["tmp_name"][$key], $file_path.$file_folder."/".$files["name"][$key]);	
				
				}
				
			}
						
			// notify the owner of the updates
			send_email_notification_up_ticket($ticket["ID"]);
			
			mysqli_close($db);
			
			header('Location: '.$_SERVER['REQUEST_URI']);
						
		}	

}

?>
<div class="margin-body" style="clear:both">

<div id="table_header"></div>

<p><a href="#" id="u-show-ticket-detail"><?php echo $lang['ticket-show-detail']; ?></a></p>

<div id="body-left" class="u-ticket-detail">
	<div class="inner-padding">
    	<?php echo $lang['ticket-details-title']; ?>
        <p><strong><?php echo $lang['tickets-ID']; ?></strong></p>
        <p><?php echo $ticket["ID"]; ?></p>
        <p><strong><?php echo $lang['search-cust']; ?></strong></p>
        <p><?php echo decode_entities($ticket["User"]); ?></p>    
        <p><strong><?php echo $lang['tickets-status']; ?></strong></p>
        <p><?php echo aa_select_ticket_status_lang($ticket["Status"]); ?></p>
        <p><strong><?php echo $lang['tickets-group']; ?></strong></p>
        <p><?php echo decode_entities($ticket["Category"]); ?></p>
        <p><strong><?php echo $lang['tickets-owner']; ?></strong></p>
        <p><?php echo decode_entities($ticket["Owned"]); ?></p>    
        <p><strong><?php echo $lang['tickets-priority']; ?></strong></p>
        <p><?php echo decode_entities($ticket["Priority"]); ?></p>
        <p><strong><?php echo decode_entities($lang['tickets-dateadd']); ?></strong></p>
        <p><?php echo $ticket["DateAdd"]; ?></p>
        <p><strong><?php echo $lang['ticket-dateintrep']; ?></strong></p>
        <p><?php echo $ticket["DateReplied"]; ?></p>
        <p><strong><?php echo $lang['tickets-dateup']; ?></strong></p>
        <p><?php echo $ticket["DateUp"]; ?></p>
        <p><strong><?php echo $lang['ticket-dateclosed']; ?></strong></p>
        <p><?php echo $ticket["DateClosed"]; ?></p>
	</div>
</div>
<?php
// define if page 60 or 80
$allow_feedback = get_settings("Ticket_Feedback");
if ($ticket["Status"] == "Closed" && $allow_feedback == 1) {
	$body_page_width = 'body-60';
	$body_right_show = true;
} else {
	$body_page_width = 'body-80';
}
?>
<div id="body-middle" class="<?php echo $body_page_width; ?>">

	<div class="outer-padding">
        
        <div class="user-message">
        	<div class="inner-padding">
        
            <span style="float:left"><b><?php echo decode_entities($ticket["User"]); ?></b></span>
            <span style="float:right"><?php echo $ticket["DateAdd"]; ?></span>
    
            <br />
            <?php echo decode_entities($ticket["Subject"]); ?>
            <hr />
            
            <p>
            <?php
            // if widget message use nl2br otherwise convert html
            echo $message = $ticket['Type'] == 'Widget' ? nl2br($ticket['Message']) : html_entity_decode($ticket["Message"]);
            ?>
            </p>
            
            <?php
            $sel_custom_fields = mysqli_query($db, "SELECT Field_Name FROM $mysql_custom_fields") or die(mysql_error());
            $count_custom_fields = mysqli_num_rows($sel_custom_fields);
            
            if ($count_custom_fields > 0 && ($ticket['Type'] == 'Web')) {
            
            ?>
            <fieldset>
            <legend><?php echo $lang['ticket-customfields']; ?></legend>
            <?php      
            while ($custom_field = mysqli_fetch_array($sel_custom_fields)) {
                  
                $custom_value = str_replace("#", "<br>", $ticket[$custom_field["Field_Name"]]);
    
                if ($custom_value == "") {
                
                    $custom_value = "N/A";
                
                }
                    
                echo "<p><b>".str_replace('_', ' ', $custom_field["Field_Name"])."</b></p><p>".nl2br($custom_value)."</p>";
                
            }      
            ?>    
            </fieldset>
            <?php
            // end count of custom fields
            }
            ?>
            <?php 
            if ($file_count) {
            ?>
            <br>
            <fieldset>
            <legend><?php echo $lang['ticket-fileuploads']; ?></legend>
            <?php
            foreach ($file_array as $file) {
            
                echo "<p><i class=\"fa fa-paperclip\"></i> <a href=\"".$file_path.$file_folder."/".$file."\" download=".$file.">".$file."</a>";
            
            }
            ?>
            </fieldset>
            <br />
            <?php	
            }
            ?>
            </div>
        </div>

		<?php
        // loop through each ticket update and print
        while ($ticket_update = mysqli_fetch_array($sel_ticket_updates)) {
        
        // if sql column is populated with files
        if ($ticket_update["Update_Files"] != "") {
            $tu_files = rtrim($ticket_update["Update_Files"], ",");
            $tu_file_array = explode(",",$tu_files);
            $tu_file_count = count($tu_file_array);
        } else {
            $tu_file_count = 0;
        }
        
        // if update not by admin print user name
        if ($ticket_update["Fname"] == NULL) {
            $name = $ticket_update["Update_By"];
        } else {
            $name = $ticket_update["Fname"]." ".$ticket_update["Lname"];
        }
        
        ?>
        <div class="user-message">
        	<div class="inner-padding">
		<?php
            if ($ticket_update["Update_Type"] == "Change") {
        
                echo html_entity_decode(stripslashes($ticket_update["Notes"]))." by <b>".$ticket_update["Fname"]." ".$ticket_update["Lname"]."</b>";
				
				echo '<br>'.$ticket_update["DateUp"]; 
          
        
            } else {
            ?>
                
        
                <span style="float:left"><b><?php echo decode_entities($name); ?></b></span>
                <span style="float:right"><?php echo $ticket_update["DateUp"]; ?></span>
                <br />
                <hr />
                <p>
                
                <?php 
				
				// if not empty show forward to address
				if (!empty($ticket_update["Forward_To"])) {
				echo $lang['ticket-forwarded-to-3rd-party'];
				}

                echo html_entity_decode(stripslashes($ticket_update["Notes"]));
                ?>
                </p>
                
                <?php 
                if ($tu_file_count) {
                ?>
                <fieldset>
                <legend><?php echo $lang['ticket-fileuploads']; ?></legend>
                <?php			
                foreach ($tu_file_array as $tu_file) {
                                        
                        echo "<p><i class=\"fa fa-paperclip\"></i> <a href=\"".$file_path.$file_folder."/".$tu_file."\" download=".$tu_file.">".$tu_file."</a> </i>";
                        
                    }
                ?>
                </fieldset>
                <?php	
                }
                ?>	 
                            
            <?php
            }
            ?>
            </div>  
   		</div>
        <?php
		
		// end while loop
        }
        ?>        

        <br />
		<?php
		// if ticket is closed user can't updadte the ticket
		if ($ticket["Status"] != "Closed") {
		?>
		
        <form method="post" action="<?php echo $_SERVER['REQUEST_URI']."#user_reply"; ?>" enctype="multipart/form-data">
        <a name="user_reply" id="user_reply"></a>
        <?php  echo "<p><span class=\"error\">".@$form_error["REPLY"]."</span></p>"; ?>
        <textarea class="reply_textarea" name="user_update" id="user_update" placeholder="Reply"><?php echo @$_POST["user_update"]; ?></textarea>
        <?php
        $file_attachment = get_settings("File_Enabled");
        
        if ($file_attachment == 1) {
       
        ?>    
        <p><strong><?php echo $lang['ticket-add-files-add']; ?></strong></p>
        <div id="fileuploads">
        <input type="hidden" id="aafilelimit" value="<?php echo get_settings("File_Limit"); ?>" />      
        <input class="aafile" name="file[]" type="file"/>
        <?php echo "<p><span class=\"error\">".@$form_error["FILE"]."</span></p>"; ?>            
        </div>
        <p><a href="#" id="addfile"><?php echo $lang['ticket-add-files-ano']; ?></a></p>
        <?php
        }
        ?>
    
        <p><input type="submit" name="user_submit" id="user_submit" value="<?php echo $lang['ticket-status-dd-update']; ?>" /></p>
        </form>
        <?php
		}
		?>
	</div>
</div>
<?php

if ($ticket["Status"] == "Closed" && $allow_feedback == 1) {

?>
<div id="body-right">
	<div class="inner-padding">
    <?php echo $lang['ticket-rate']; ?>
    <div id="ticket_values" ticket_id="<?php echo $ticket["ID"]; ?>" user_id="<?php echo $ticket["User"]; ?>"></div>
    <ul id="rating">
    <?php
	// array for rating. number is sql value
	$ratings = array("2" => $lang['ticket-rate-p'], "1" => $lang['ticket-rate-neu'], "0" => $lang['ticket-rate-neg']);
	foreach ($ratings as $rating_key => $rating_value) {
		
		switch ($rating_key) {
			case "2":
				$aa_rating_style = "Positive";
				break;
			case "1":
				$aa_rating_style = "Neutrel";
				break;
			case "0":
				$aa_rating_style = "Negative";
				break;
		}
			
		// if no rating submited
		if ($ticket["Feedback"] == NULL) {

    		echo "<li id=\"".$aa_rating_style."\" rval=\"".$rating_key."\"><a href=\"#\">".ucwords($rating_value)."</a></li>";			

		// if feedback given and matches db
		} else if ($ticket["Feedback"] == $rating_key) {
    
    		echo "<li id=\"".$aa_rating_style."\" class=\"selected\" rval=\"".$rating_key."\">".ucwords($rating_value)." <i class=\"fa fa-check\"></i></li>";
	
		// else must be unselected options
		} else {
			
    		echo "<li id=\"".$aa_rating_style."\" class=\"disabled-li\" rval=\"".$rating_key."\">".ucwords($rating_value)."</li>";			
			
		}
	
	}
	
	?>
    </ul>
    </div>
</div>

<?php
}
?>
</div>


