# Copyright 2000-2004, Fred Steinberg, Brown Bear Software

# View/Set Users in a group

package SysUserGroupAdmin;
use strict;
use CGI (':standard');
use Calendar::User;
use Calendar::UserGroup;

use vars ('@ISA');
@ISA = ('Operation');

sub perform {
    my $self = shift;

    my ($groupID, $groupName, $userName, $save, $cancel) =
                 $self->getParams (qw (GroupID GroupName UserName
                                       Save Cancel));
    my $i18n  = $self->I18N;
    my $prefs = $self->prefs;

    # If both specified, decide based on button pressed to get here
    if (defined $userName and defined $groupName) {
        undef $userName  if param ('ByGroup');
        undef $groupName if param ('ByUser');
    }

    my $theUser;
    if (defined $userName) {
        $theUser = User->getUser ($userName);
    }

    if (!$theUser and defined $groupName) {
        # lookup ID for group name
        my $group = UserGroup->getByName ($groupName);
        $groupID = $group->id if ($group);
    }

    if ($cancel or $self->calendarName or (!$groupID and !$theUser)) {
        print $self->redir ($self->makeURL ({Op => 'SysUserGroups'}));
        return;
    }

    if (defined $groupID) {
        my $theGroup = UserGroup->getGroup ($groupID);
        $groupName = $theGroup->name;
    }

    my %allUsers = map {$_->name => $_} User->getUsers;
    my @allUserNames = sort {lc($a) cmp lc($b)} keys %allUsers;

    if ($save) {
        $self->{audit_formsaved}++;
        my @selectedItems = param ('SelectionList');
        my %selected = map {$_ => 1} @selectedItems;

        # If modifying users for a group:
        #   modify each user, if their membership  for this group changed
        if ($groupID) {
            while (my ($name, $user) = each %allUsers) {
                my @groups = $user->groupIDs;
                my $inGroup = grep {$groupID == $_} @groups;
                if ($selected{$name} and !$inGroup) {
                    $user->addToGroup ($groupID);
                }
                elsif (!$selected{$name} and $inGroup) {
                    $user->removeFromGroup ($groupID);
                }
            }
        }

        # If modifying groups for a user:
        if ($theUser) {
            my @allGroups = UserGroup->getAll;
            my %nameToID = map {$_->name => $_->id} @allGroups;
            my @groupIDs = map {$nameToID{$_}} @selectedItems;
            $theUser->setGroups (@groupIDs);
        }
    }

    my $title;
    my (@items, @selected);   # either users in group, or groups for the user
    my ($head, $subHead);

    if ($theUser) {
        $title   = 'Groups for a User';
        $head    = $i18n->get ('User') . ": $userName";
        $subHead = $i18n->get ('Assign Groups');
        my @allGroups = UserGroup->getAll;
        my %idToName = map {$_->id => $_->name} @allGroups;
        @selected = map {$idToName{$_}} $theUser->groupIDs;
        @items    = sort {lc ($a) cmp lc ($b)}
                     map {$_->name} @allGroups;
    } else {
        $title   = 'User Group Members';
        $head    = $i18n->get ('Group') . ": $groupName";
        $subHead = $i18n->get ('Assign Users');
        @items = @allUserNames;
        # Get users in this group
        foreach my $user (values %allUsers) {
            next unless grep {$_ == $groupID} $user->groupIDs;
            push @selected, $user->name;
        }
    }

    # And display (or re-display) the form
    print GetHTML->startHTML (title => $i18n->get ($title));
    print GetHTML->SysAdminHeader ($i18n, $title, 1);

    print startform;

    print '<center>';
    print h2 ($head);
    print h3 ($subHead);

    print scrolling_list (-name     => "SelectionList",
                          -Values   => \@items,
                          -defaults => \@selected,
                          -size     => 10,
                          -multiple => 'true');

    print '<br>';
    print '<small><b>' . $i18n->get ('Note') . ': </b>';
    print $i18n->get ('control-click to choose multiple items.');
    print '</small>';
    print '</center>';

    print '<hr>';
    print submit (-name  => 'Save',
                  -value => $i18n->get ('Save'));
    print '&nbsp;';
    print submit (-name  => 'Cancel',
                  -value => $i18n->get ('Done'));
    print '&nbsp;';
    print reset (-value  => 'Reset');
    print hidden (-name => 'Op',       -value => __PACKAGE__);
    print hidden (-name => 'GroupID',  -value => $groupID)
        if (defined $groupID);
    print hidden (-name => 'UserName', -value => $userName)
        if (defined $userName);

    print endform;
    print end_html;
}

sub cssDefaults {
    my $self = shift;
    my $css = $self->SUPER::cssDefaults;
    $css .= GetHTML->AdminCSS ($self);
    return $css;
}

sub auditString {
    my ($self, $short) = @_;
    return unless $self->{audit_formsaved};
    my $summary =  $self->SUPER::auditString ($short);
}

1;
